/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gendoc.m2t.IFragmentableM2TProcessor;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.acceleo.Generator;
import org.eclipse.gendoc.script.acceleo.Messages;
import org.eclipse.gendoc.script.acceleo.ServicesExtension;
import org.eclipse.gendoc.script.acceleo.impl.FragmentScriptGenerator;
import org.eclipse.gendoc.script.acceleo.impl.ScriptGenerator;
import org.eclipse.gendoc.script.services.IModuleManagerService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.services.exception.ElementNotFoundException;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.GenerationException;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.services.exception.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoM2TProcess
implements IFragmentableM2TProcessor {
    public String runScript(String script, EObject element) throws ModelNotFoundException, ElementNotFoundException, ParsingException, GenerationException {
        return this.doRunScript(script, element, new ScriptGenerator(this.getScriptPatterns()));
    }

    protected String doRunScript(String script, EObject element, ScriptGenerator scriptGenerator) throws GenerationException {
        String result = "";
        String formattedScript = "";
        try {
            formattedScript = scriptGenerator.formatScript(element, script);
            result = this.generate(element, formattedScript);
        }
        catch (IOException e) {
            throw new GenerationException("Error during generation of the following script : \n" + script, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException && "index: 0, size: 1".equals(e.getMessage())) {
                throw new GenerationException("Error while trying to access index 0 of list.\n TIP : In Acceleo, index start at 1 and not 0.");
            }
            throw new GenerationException("Error during generation of Gendoc script :" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String generate(EObject element, String formattedScript) throws IOException, ParsingException, GenerationException {
        IModuleManagerService service = (IModuleManagerService)GendocServices.getDefault().getService(IModuleManagerService.class);
        Generator generator = new Generator(element, formattedScript, service.getModuleURIs(element));
        IProgressMonitorService progressMonitor = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
        String result = generator.doGenerate(progressMonitor.getDelegatingMonitor());
        this.unload(generator.getResourceSet());
        return result;
    }

    private void unload(ResourceSet resourceSet) {
        for (Resource r : resourceSet.getResources()) {
            try {
                if (r.getURI().scheme().equals(Messages.GendocResourceFactory_BUNDLE_URI_SCHEME)) continue;
                r.unload();
            }
            catch (Exception exception) {}
        }
    }

    public List<String> getAllAvailableBundles() {
        return ServicesExtension.getInstance().getServices();
    }

    public List<Pattern> getScriptPatterns() {
        Pattern braquets = Pattern.compile("(\\[[^\\[\\]]*\\])|(\\[/[^\\[\\]]*\\])");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(1);
        patterns.add(braquets);
        return patterns;
    }

    public String runFragmentScript(EObject element, Fragment fragment) throws GenDocException {
        FragmentScriptGenerator generator = new FragmentScriptGenerator(this.getScriptPatterns(), fragment);
        return generator.formatScript(element, fragment.getScriptValue());
    }

    public void clear() {
    }
}

