/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.docx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gendoc.document.parser.Activator;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.docx.DocxFactory;
import org.eclipse.gendoc.document.parser.documents.helper.DOCXHelper;
import org.eclipse.gendoc.document.parser.documents.helper.OfficeHelper;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocxDocument
extends AbstractZipDocument {
    private XMLParser style = new XMLParser(this.getUnzipper().getFile("styles.xml"));
    private DocxDocument subDoc = null;

    public DocxDocument(File document) throws IOException {
        this(document, null);
    }

    public DocxDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public DocxDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
    }

    public String getStyle() {
        String tagValue = XMLHelper.getTagValueWithoutNamespace(this.getXMLParser().getCurrentNode());
        if ("pStyle".equals(tagValue) && DOCXHelper.getNodeForStyleNode(this.getXMLParser().getCurrentNode()) != null && DOCXHelper.isNotAModification(DOCXHelper.getNodeForStyleNode(this.getXMLParser().getCurrentNode()))) {
            String styleName = this.getXMLParser().getCurrentNode().getAttributes().getNamedItem("w:val").getNodeValue();
            return DOCXHelper.getStringStyleForStyleNodeInStyleFile(styleName, this.style);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean next() {
        if (this.subDoc == null) {
            Node node = this.getXMLParser().getCurrentNode();
            if (node == null || !"w:subDoc".equals(node.getNodeName())) return super.next();
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null) {
                return super.next();
            }
            Node namedItem = attributes.getNamedItem("r:id");
            if (namedItem == null) {
                return super.next();
            }
            String id = namedItem.getNodeValue();
            String subDocFile = OfficeHelper.retrieveRelationshipSubDocument(this.getUnzipper(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/subDocument", "document.xml.rels", id);
            try {
                this.subDoc = (DocxDocument)DocxFactory.getInstance().loadDocument(this.getDocumentURL().toURI().resolve(subDocFile).toURL());
                return true;
            }
            catch (MalformedURLException ex) {
                Activator.log(ex);
                return true;
            }
            catch (URISyntaxException ex) {
                Activator.log(ex);
            }
            return true;
        } else {
            boolean next = this.subDoc.next();
            if (next) return next;
            this.subDoc = null;
            return super.next();
        }
    }

    @Override
    public XMLParser getXMLParser() {
        if (this.subDoc != null) {
            return this.subDoc.getXMLParser();
        }
        return super.getXMLParser();
    }

    @Override
    public String getTextCorrespondingToCurrentStyle() {
        String result = null;
        if (this.getStyle() != null) {
            return DOCXHelper.getTextNodeForStyleNode(this.getXMLParser().getCurrentNode());
        }
        return result;
    }

    public String getText() {
        StringBuffer result = new StringBuffer("");
        Node n = this.getXMLParser().getCurrentNode();
        if ("w:p".equals(n.getNodeName())) {
            Node tmp = XMLHelper.next(n);
            while (tmp != null && !"w:p".equals(tmp.getNodeName())) {
                if ("w:t".equals(tmp.getNodeName())) {
                    result.append(tmp.getTextContent());
                }
                tmp = XMLHelper.next(tmp);
            }
        }
        return result.toString();
    }

    @Override
    public Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        LinkedList<XMLParser> parsers = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                XMLParser p = new XMLParser(this.getUnzipper().getFile("document.xml"), idForDocument);
                parsers.add(p);
                break;
            }
            case footer: {
                OfficeHelper.fillCollection(this.getUnzipper(), parsers, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer", idForDocument, "document.xml.rels");
                break;
            }
            case header: {
                OfficeHelper.fillCollection(this.getUnzipper(), parsers, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header", idForDocument, "document.xml.rels");
                break;
            }
            case comment: {
                OfficeHelper.fillCollection(this.getUnzipper(), parsers, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments", idForDocument, "document.xml.rels");
            }
        }
        return parsers;
    }

    @Override
    public Object get(Document.PROPERTY property) {
        switch (property) {
            case style: {
                return this.getStyle();
            }
            case text: {
                return this.getText();
            }
        }
        return null;
    }
}

