/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.document.parser.Activator;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.DocumentFactory;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;

public class DocumentManager
extends AbstractService
implements IDocumentManager {
    private Document docTemplate;
    private Map<Object, Document> documents = new HashMap<Object, Document>();

    public void clear() {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        for (Document d : this.documents.values()) {
            if (!(d instanceof AbstractZipDocument)) continue;
            AbstractZipDocument zip = (AbstractZipDocument)d;
            documentService.clean(zip.getUnzipLocationDocumentFile());
        }
        this.documents.clear();
    }

    @Override
    public Document getDocTemplate() {
        return this.docTemplate;
    }

    @Override
    public Document getDocument(File templateDoc) {
        Document result = this.documents.get(templateDoc);
        if (result == null) {
            DocumentFactory factory = Activator.getFactoryFromExtension((String)templateDoc.getAbsolutePath());
            Map<Document.CONFIGURATION, Boolean> conf = this.initConf();
            try {
                result = factory.loadDocument(templateDoc.toURI().toURL(), conf);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (result != null) {
                this.documents.put(templateDoc, result);
            }
        }
        return result;
    }

    @Override
    public void setDocTemplate(Document docTemplate) {
        this.docTemplate = docTemplate;
    }

    private Map<Document.CONFIGURATION, Boolean> initConf() {
        HashMap<Document.CONFIGURATION, Boolean> result = new HashMap<Document.CONFIGURATION, Boolean>();
        result.put(Document.CONFIGURATION.content, true);
        result.put(Document.CONFIGURATION.header, true);
        result.put(Document.CONFIGURATION.footer, true);
        return result;
    }

    @Override
    public Document getDocument(URL url) {
        Document result = this.documents.get(url.toString());
        if (result == null) {
            DocumentFactory factory = Activator.getFactoryFromExtension((String)url.getPath());
            Map<Document.CONFIGURATION, Boolean> conf = this.initConf();
            result = factory.loadDocument(url, conf);
            this.documents.put(url.toString(), result);
        }
        return result;
    }
}

