/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.helper;

import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.docx.DocxNamespaceContext;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOCXHelper {
    public static final String CONTENTS_FILE_NAME = "document.xml";
    public static final String STYLE_FILE_NAME = "styles.xml";
    public static final String DOCUMENT_RELS_FILE_NAME = "document.xml.rels";
    public static final String PROPERTIES_CUSTOM_FILE_NAME = "docProps/custom.xml";
    public static final String PROPERTIES_CORE_FILE_NAME = "docProps/core.xml";
    public static final String XPATH_ALL_STYLES = "//w:style";
    public static final String WORD_STYLE = "pStyle";
    public static final String WORD_STYLE_ATTRIBUTE = "w:val";
    public static final String WORD_STYLE_PARAGRAPH = "p";
    public static final String WORD_STYLE_PARAGRAPH_W = "w:p";
    public static final String WORD_STYLE_PARAGRAPH_RPR = "w:rPr";
    public static final String WORD_STYLE_TEXT = "t";
    public static final String WORD_STYLE_TEXT_W = "w:t";
    public static final String WORD_SUB_DOC = "w:subDoc";
    public static final String WORD_SUB_DOC_ID = "r:id";
    public static final String WORD_TAG_CHANGE_INS = "ins";
    public static final String WORD_TAG_CHANGE_DEL = "del";
    public static final String WORD_TAG_CHANGE = "pPrChange";
    public static final String WORD_TAG_CHANGE_FORMAT = "rPrChange";
    public static final String DOCUMENT_BODY = "w:body";
    public static final String RELATIONSHIPS_HEADER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header";
    public static final String RELATIONSHIPS_FOOTER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer";
    public static final String RELATIONSHIPS_COMMENTS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments";
    public static final String RELATIONSHIPS_SUB_DOCUMENTS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/subDocument";
    private static final String WORD_NODE_NAME = "w:name";
    private static final String DOCX_W_STYLE_ID = "w:styleId";

    private DOCXHelper() {
    }

    public static String getTextForParagraphOfGivenNode(Node n) {
        StringBuffer text = new StringBuffer();
        if (n != null) {
            Node parent = n;
            while (parent != null && !WORD_STYLE_PARAGRAPH_W.equals(parent.getNodeName())) {
                parent = parent.getParentNode();
            }
            if (parent != null) {
                Node sibling = XMLHelper.getSibling(parent);
                Node nTmp = parent;
                while (nTmp != sibling) {
                    if ((nTmp = XMLHelper.next(nTmp)) == null || !WORD_STYLE_TEXT_W.equals(nTmp.getNodeName())) continue;
                    text.append(nTmp.getTextContent());
                }
            }
        }
        return text.toString();
    }

    public static String getTextNodeForStyleNode(Node n) {
        return DOCXHelper.getTextNodeForStyleNode(n, null);
    }

    public static String getTextNodeForStyleNode(Node n, String forbiddenProperties) {
        StringBuffer text = new StringBuffer();
        if (n != null && n.getParentNode() != null) {
            Node parent = n.getParentNode();
            while (parent != null && !WORD_STYLE_PARAGRAPH_W.equals(parent.getNodeName())) {
                parent = parent.getParentNode();
            }
            if (parent != null) {
                Node nTmp = n;
                Node sibling = XMLHelper.getSibling(parent);
                while (nTmp != sibling) {
                    nTmp = XMLHelper.next(nTmp);
                    if (forbiddenProperties != null && forbiddenProperties.length() > 0 && WORD_STYLE_PARAGRAPH_RPR.equals(nTmp.getNodeName()) && !DOCXHelper.rPrOk(nTmp, forbiddenProperties)) {
                        nTmp = XMLHelper.getSibling(nTmp.getParentNode());
                    }
                    if (nTmp == null || !WORD_STYLE_TEXT_W.equals(nTmp.getNodeName())) continue;
                    text.append(nTmp.getTextContent());
                }
            }
        }
        return text.toString();
    }

    private static boolean rPrOk(Node current, String forbiddenProperties) {
        Node tmp = current;
        if (forbiddenProperties == null || forbiddenProperties.length() == 0) {
            return true;
        }
        boolean result = true;
        Node end = XMLHelper.getSibling(tmp);
        while (result && tmp != end) {
            if (!forbiddenProperties.equals((tmp = XMLHelper.next(tmp)).getNodeName())) continue;
            result = false;
        }
        return result;
    }

    public static Node getNodeForStyleNode(Node n) {
        Node result = null;
        if (WORD_STYLE.equals(XMLHelper.getTagValueWithoutNamespace(n))) {
            Node paragraph = n.getParentNode();
            while ((paragraph = XMLHelper.next(paragraph)) != null && !WORD_STYLE_PARAGRAPH.equals(XMLHelper.getTagValueWithoutNamespace(paragraph)) && !WORD_STYLE_TEXT.equals(XMLHelper.getTagValueWithoutNamespace(paragraph))) {
            }
            if (paragraph != null && WORD_STYLE_TEXT.equals(XMLHelper.getTagValueWithoutNamespace(paragraph))) {
                result = paragraph;
            }
        }
        return result;
    }

    public static String getStringStyleForStyleNodeInStyleFile(String result, XMLParser xml) {
        String theResult = result;
        Node n = xml.evaluateXPathExpression(XPATH_ALL_STYLES, DOCX_W_STYLE_ID, result, new DocxNamespaceContext());
        if (n != null) {
            NodeList l = n.getChildNodes();
            boolean found = false;
            int i = 0;
            while (!found && i < l.getLength()) {
                Node ntmp = l.item(i);
                if (WORD_NODE_NAME.equals(ntmp.getNodeName())) {
                    theResult = ntmp.getAttributes().getNamedItem(WORD_STYLE_ATTRIBUTE).getNodeValue();
                    found = true;
                }
                ++i;
            }
        }
        return theResult;
    }

    public static Node jumpToNextNodeNamed(Node n, String s) {
        if (s == null || n == null) {
            return null;
        }
        Node result = n;
        while ((result = XMLHelper.next(result)) != null && !s.equals(result.getNodeName())) {
        }
        return result;
    }

    public static boolean isNotAModification(Node currentNode) {
        boolean change = DOCXHelper.isContainedBySpecificTag(currentNode, WORD_TAG_CHANGE_INS, WORD_STYLE_PARAGRAPH) || DOCXHelper.isContainedBySpecificTag(currentNode, WORD_TAG_CHANGE_DEL, WORD_STYLE_PARAGRAPH) || DOCXHelper.isContainedBySpecificTag(currentNode, WORD_TAG_CHANGE, WORD_STYLE_PARAGRAPH) || DOCXHelper.isContainedBySpecificTag(currentNode, WORD_TAG_CHANGE_FORMAT, WORD_STYLE_PARAGRAPH);
        return !change;
    }

    public static boolean isContainedBySpecificTag(Node n, String search, String limit) {
        Node tmp = n;
        while (!search.equals(XMLHelper.getTagValueWithoutNamespace(tmp = tmp.getParentNode())) && !limit.equals(XMLHelper.getTagValueWithoutNamespace(tmp))) {
        }
        return search.equals(XMLHelper.getTagValueWithoutNamespace(tmp));
    }
}

