/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.odt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.DocumentFactory;
import org.eclipse.gendoc.document.parser.documents.odt.ODTDocument;

public class ODTFactory
implements DocumentFactory {
    private static ODTFactory instance = new ODTFactory();

    public static DocumentFactory getInstance() {
        return instance;
    }

    @Override
    public Document loadDocument(File file) {
        return this.loadDocument(file, null);
    }

    @Override
    public Document loadDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        try {
            return this.loadDocument(documentFile.toURI().toURL(), configuration);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document loadDocument(URL documentFile) {
        return this.loadDocument(documentFile, null);
    }

    @Override
    public Document loadDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        ODTDocument document = new ODTDocument(documentFile, configuration);
        return document;
    }
}

