/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.internal.registry.MapRegistry;

public class DefaultActionRegistry
extends MapRegistry<String, Map<String, Class<? extends Action>>>
implements ActionRegistry {
    @Override
    public boolean register(String diagramType, String actionKind, Class<? extends Action> actionClass) {
        Map actionMap = this.elements.computeIfAbsent(diagramType, k -> new HashMap());
        Class<? extends Action> existing = actionMap.putIfAbsent(actionKind, actionClass);
        if (existing != null && existing != actionClass) {
            throw new IllegalArgumentException(String.format("Conflicting registration! Another class is already registered for action kind '%s'. Conflicting classes: '%s', '%s'", actionKind, existing, actionClass));
        }
        return existing == null;
    }

    @Override
    public boolean register(String diagramType, Map<String, Class<? extends Action>> actionMap) {
        return actionMap.entrySet().stream().allMatch(entry -> this.register(diagramType, (String)entry.getKey(), (Class)entry.getValue()));
    }

    @Override
    public List<String> getHandledActionKinds(String diagramType) {
        return this.get(diagramType).map(map -> new ArrayList(map.keySet())).orElse(new ArrayList());
    }

    @Override
    public Map<String, List<String>> getHandledActionKinds() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.keys().forEach(diagramType -> result.put((String)diagramType, this.getHandledActionKinds((String)diagramType)));
        return result;
    }

    @Override
    public Map<String, Class<? extends Action>> getAllAsMap() {
        HashMap<String, Class<? extends Action>> result = new HashMap<String, Class<? extends Action>>();
        this.getAll().forEach(actionMap -> result.putAll((Map<String, Class<? extends Action>>)actionMap));
        return result;
    }
}

