/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.IElementDeltaBuilder;

public class ElementChangeRecorder {
    private IElement inputElement;
    private IElementDeltaBuilder deltaBuilder;
    private int maxDepth;
    private Map<IElement, Object> oldBodies;
    private Map<IElement, ListItem> oldPositions;
    private Map<IElement, ListItem> newPositions;
    private Set<IElement> added;
    private Set<IElement> removed;
    private boolean recording;

    public final boolean isRecording() {
        return this.recording;
    }

    public final void beginRecording(IElement inputElement) {
        this.beginRecording(inputElement, null);
    }

    public final void beginRecording(IElement inputElement, IElementDeltaBuilder deltaBuilder) {
        this.beginRecording(inputElement, deltaBuilder, Integer.MAX_VALUE);
    }

    public void beginRecording(IElement inputElement, IElementDeltaBuilder deltaBuilder, int maxDepth) {
        if (inputElement == null) {
            throw new IllegalArgumentException();
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (deltaBuilder == null) {
            deltaBuilder = this.newDeltaBuilder(inputElement);
        }
        this.inputElement = inputElement;
        this.deltaBuilder = deltaBuilder;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordBody(inputElement, 0);
        this.recording = true;
    }

    public IElementDeltaBuilder endRecording() {
        if (!this.recording) {
            throw new IllegalStateException("No recording to end");
        }
        this.recording = false;
        this.recordNewPositions(this.inputElement, 0);
        this.findChanges(this.inputElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.inputElement, 0);
        return this.deltaBuilder;
    }

    protected final IElement getInputElement() {
        return this.inputElement;
    }

    protected final IElementDeltaBuilder getDeltaBuilder() {
        return this.deltaBuilder;
    }

    protected final int getMaxDepth() {
        return this.maxDepth;
    }

    protected IElementDeltaBuilder newDeltaBuilder(IElement element) {
        ElementDelta.Factory deltaFactory = Elements.getModelContext(element).get(ElementDelta.Factory.class);
        ElementDelta delta = deltaFactory != null ? deltaFactory.newDelta(element) : new ElementDelta(element);
        return new ElementDelta.Builder(delta);
    }

    protected void recordBody(Object body, IElement element) {
        this.oldBodies.put(element, body);
    }

    protected void findContentChange(Object oldBody, Object newBody, IElement element) {
        ((Body)newBody).findContentChange((Body)oldBody, element, this.deltaBuilder);
    }

    private void initialize() {
        this.oldBodies = new HashMap<IElement, Object>(20);
        this.oldPositions = new HashMap<IElement, ListItem>(20);
        this.newPositions = new HashMap<IElement, ListItem>(20);
        this.oldPositions.put(this.inputElement, new ListItem(null, null));
        this.newPositions.put(this.inputElement, new ListItem(null, null));
        this.added = new HashSet<IElement>(5);
        this.removed = new HashSet<IElement>(5);
    }

    private void recordBody(IElement element, int depth) {
        Object body;
        try {
            body = ((IElementImplExtension)element).getBody_();
        }
        catch (CoreException e) {
            return;
        }
        this.recordBody(body, element);
        if (depth == this.maxDepth) {
            return;
        }
        IElement[] children = ((IElementImplExtension)element).getChildrenFromBody_(body);
        this.insertPositions(children, false);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.recordBody(child, depth + 1);
            ++n2;
        }
    }

    private void recordNewPositions(IElement newElement, int depth) {
        IElement[] children;
        if (depth == this.maxDepth) {
            return;
        }
        try {
            children = Elements.getChildren(newElement);
        }
        catch (CoreException e) {
            return;
        }
        this.insertPositions(children, true);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.recordNewPositions(child, depth + 1);
            ++n2;
        }
    }

    private void insertPositions(IElement[] elements, boolean isNew) {
        int length = elements.length;
        IElement previous = null;
        IElement current = null;
        IElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IElement iElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.newPositions.put(current, new ListItem(previous, next));
            } else {
                this.oldPositions.put(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private void findChanges(IElement element, int depth) {
        Object oldBody = this.removeOldBody(element);
        if (oldBody == null) {
            this.deltaBuilder.added(element);
            this.added(element);
        } else {
            Object newBody;
            try {
                newBody = ((IElementImplExtension)element).getBody_();
            }
            catch (CoreException e) {
                this.deltaBuilder.removed(element);
                this.removed(element);
                return;
            }
            if (depth == this.maxDepth) {
                this.deltaBuilder.changed(element, 1L);
                return;
            }
            if (oldBody != newBody) {
                this.findContentChange(oldBody, newBody, element);
            }
            IElement[] iElementArray = ((IElementImplExtension)element).getChildrenFromBody_(newBody);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.findChanges(child, depth + 1);
                ++n2;
            }
        }
    }

    private void findDeletions() {
        for (IElement element : this.oldBodies.keySet()) {
            this.deltaBuilder.removed(element);
            this.removed(element);
        }
    }

    private void findChangesInPositioning(IElement element, int depth) {
        IElement[] children;
        if (this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            long flags = 16L;
            if (depth < this.maxDepth) {
                flags |= 0x20L;
            }
            this.deltaBuilder.changed(element, flags);
        }
        if (depth == this.maxDepth) {
            return;
        }
        try {
            children = Elements.getChildren(element);
        }
        catch (CoreException e) {
            return;
        }
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            this.findChangesInPositioning(child, depth + 1);
            ++n2;
        }
    }

    private void added(IElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removed(IElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private boolean isPositionedCorrectly(IElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IElement oldPrevious = oldListItem.previous;
        IElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private Object removeOldBody(IElement element) {
        return this.oldBodies.remove(element);
    }

    private ListItem getOldPosition(IElement element) {
        return this.oldPositions.get(element);
    }

    private ListItem getNewPosition(IElement element) {
        return this.newPositions.get(element);
    }

    private static class ListItem {
        public IElement previous;
        public IElement next;

        public ListItem(IElement previous, IElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

