/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ContainerElementConstraintSetTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintSetTest.webArchiveBuilder().withTestClass(ContainerElementConstraintSetTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void field_constraint_provided_on_type_parameter_of_a_set_gets_validated() {
        TypeWithSet1 s = new TypeWithSet1();
        s.names = CollectionHelper.asSet("First", "", null);
        Set constraintViolations = this.getValidator().validate((Object)s, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraints_specified_on_set_and_on_type_parameter_of_set_get_validated() {
        TypeWithSet2 s = new TypeWithSet2();
        s.names = CollectionHelper.asSet("First", "", null);
        Set constraintViolations = this.getValidator().validate((Object)s, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("names").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
        s = new TypeWithSet2();
        s.names = new HashSet();
        constraintViolations = this.getValidator().validate((Object)s, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("names").withInvalidValue(s.names));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void getter_constraint_provided_on_type_parameter_of_a_set_gets_validated() {
        TypeWithSet3 s = new TypeWithSet3();
        s.strings = new HashSet();
        s.strings.add("First");
        s.strings.add("");
        s.strings.add(null);
        Set constraintViolations = this.getValidator().validate((Object)s, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("strings").containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void return_value_constraint_provided_on_type_parameter_of_a_set_gets_validated() throws Exception {
        Method method = TypeWithSet4.class.getDeclaredMethod("returnStrings", new Class[0]);
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)new TypeWithSet4(), method, CollectionHelper.asSet("First", "", null), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStrings").returnValue().containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void method_parameter_constraint_provided_as_type_parameter_of_a_set_gets_validated() throws Exception {
        Method method = TypeWithSet5.class.getDeclaredMethod("setValues", Set.class);
        Object[] values = new Object[]{CollectionHelper.asSet("", "First", null)};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)new TypeWithSet5(), method, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constructor_parameter_constraint_provided_on_type_parameter_of_a_set_gets_validated() throws Exception {
        Constructor constructor = TypeWithSet6.class.getDeclaredConstructor(Set.class);
        Object[] values = new Object[]{CollectionHelper.asSet("", "First", null)};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithSet6.class).parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(""), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithSet6.class).parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithSet6.class).parameter("setParameter", 0).containerElement("<iterable element>", true, null, null, Set.class, 0)).withInvalidValue(null));
    }

    private static class TypeWithSet6 {
        public TypeWithSet6(Set<@NotNull @NotBlank String> setParameter) {
        }
    }

    private static class TypeWithSet5 {
        private TypeWithSet5() {
        }

        public void setValues(Set<@NotNull @NotBlank String> setParameter) {
        }
    }

    private static class TypeWithSet4 {
        private Set<String> strings;

        private TypeWithSet4() {
        }

        public Set<@NotNull @NotBlank String> returnStrings() {
            return this.strings;
        }
    }

    private static class TypeWithSet3 {
        private Set<String> strings;

        private TypeWithSet3() {
        }

        public Set<@NotNull @NotBlank String> getStrings() {
            return this.strings;
        }
    }

    private static class TypeWithSet2 {
        @Size(min=1)
        private @Size(min=1) Set<@NotBlank String> names;

        private TypeWithSet2() {
        }
    }

    private static class TypeWithSet1 {
        private Set<@NotNull @NotBlank String> names;

        private TypeWithSet1() {
        }
    }
}

