/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.Lists;

public final class Throwables {
    private static final String ORG_ASSERTJ_CORE_ERROR_CONSTRUCTOR_INVOKER = "org.assertj.core.error.ConstructorInvoker";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String ORG_ASSERTJ = "org.assert";

    public static void appendStackTraceInCurrentThreadToThrowable(Throwable t, String methodToStartFrom) {
        ArrayList<StackTraceElement> stackTrace = Lists.newArrayList(t.getStackTrace());
        stackTrace.addAll(Throwables.stackTraceInCurrentThread(methodToStartFrom));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    private static List<StackTraceElement> stackTraceInCurrentThread(String methodToStartFrom) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (methodToStartFrom.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        return Lists.newArrayList(Thread.currentThread().getStackTrace());
    }

    public static void removeAssertJRelatedElementsFromStackTrace(Throwable throwable) {
        ArrayList<StackTraceElement> filtered = Lists.newArrayList(throwable.getStackTrace());
        StackTraceElement previous = null;
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getClassName().contains(ORG_ASSERTJ)) {
                filtered.remove(element);
                if (previous != null && JAVA_LANG_REFLECT_CONSTRUCTOR.equals(previous.getClassName()) && element.getClassName().contains(ORG_ASSERTJ_CORE_ERROR_CONSTRUCTOR_INVOKER)) {
                    filtered.remove(previous);
                }
            }
            previous = element;
        }
        StackTraceElement[] newStackTrace = filtered.toArray(new StackTraceElement[filtered.size()]);
        throwable.setStackTrace(newStackTrace);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if (throwable.getCause() == null) {
            return null;
        }
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable throwable) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            string = sw.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            Closeables.closeQuietly(sw, pw);
            throw throwable2;
        }
        Closeables.closeQuietly(sw, pw);
        return string;
    }

    private Throwables() {
    }
}

