/*
 * Copyright (c) 2009, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * $Id:i$
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;

import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AddServletNotFound extends GenericServlet {

  public void service(ServletRequest request, ServletResponse response)
      throws ServletException, IOException {

    PrintWriter pw = response.getWriter();

    pw.println("AddServletNotFound is invoked");
    ServletTestUtil.printResult(pw, true);

    ArrayList result = (ArrayList) getServletContext()
        .getAttribute("arraylist");

    for (Object tmp : result) {
      pw.println(tmp.toString());

    }
    getServletContext().removeAttribute("arraylist");

    result = StaticLog.getClear();
    if (result != null) {
      for (Object tmp : result) {
        if (tmp != null) {
          pw.println(tmp.toString());
        }
      }
    }
    StaticLog.clear();
  }
}
