/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.service.repository.RepositoryContent;

public class TargetRepository
extends BaseRepository
implements RepositoryPlugin {
    private static final TargetRepository instance = new TargetRepository();
    private static final Map<File, ContentCapabilityCache> contentCapabilityMap = new ConcurrentHashMap<File, ContentCapabilityCache>();

    private TargetRepository() {
    }

    public File get(String bsn, aQute.bnd.version.Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        Optional<BundleDescription> description = TargetRepository.getTargetPlatformState().map(state -> state.getBundle(bsn, TargetRepository.convert(version)));
        if (description.isEmpty()) {
            return null;
        }
        Optional<File> bundle = description.map(BundleDescription::getLocation).map(location -> new File((String)location)).filter(File::isFile).or(() -> {
            IPluginModelBase model = PluginRegistry.findModel((Resource)description.get());
            if (model != null) {
                IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
                String installLocation = model.getInstallLocation();
                if (libraries.length == 0) {
                    return Optional.of(new File(installLocation));
                }
                IPluginLibrary[] iPluginLibraryArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginLibrary library = iPluginLibraryArray[n2];
                    if (!"resource".equals(library.getType())) {
                        String name = library.getName();
                        String expandedName = ClasspathUtilCore.expandLibraryName(name);
                        return Optional.of(new File(installLocation, expandedName));
                    }
                    ++n2;
                }
            }
            return Optional.empty();
        });
        if (bundle.isPresent()) {
            File file = bundle.get();
            RepositoryPlugin.DownloadListener[] downloadListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryPlugin.DownloadListener l = downloadListenerArray[n2];
                try {
                    l.success(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            return file;
        }
        return null;
    }

    public boolean canWrite() {
        return true;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        State state = TargetRepository.getTargetPlatformState().get();
        Hashtable headers = new Hashtable();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarInputStream jar = new JarInputStream(stream);){
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.entrySet().forEach(e -> {
                String string = headers.put(e.getKey().toString(), e.getValue().toString());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        BundleDescription description = state.getFactory().createBundleDescription(state, headers, null, state.getHighestBundleId() + 1L);
        RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
        result.alreadyReleased = state.updateBundle(description);
        if (!result.alreadyReleased) {
            state.addBundle(description);
        }
        result.digest = options.digest;
        return result;
    }

    public List<String> list(String glob) throws Exception {
        Stream<String> stream = TargetRepository.bundles(null).map(BundleDescription::getSymbolicName).distinct();
        if (glob != null) {
            Instruction pattern = new Instruction(glob);
            stream = stream.filter(bsn -> pattern.matches(bsn));
        }
        return stream.collect(Collectors.toList());
    }

    public SortedSet<aQute.bnd.version.Version> versions(String bsn) throws Exception {
        return TargetRepository.bundles(bsn).filter(bd -> bd.getLocation() != null).map(bundle -> bundle.getVersion()).map(v -> TargetRepository.convert(v)).collect(Collectors.toCollection(TreeSet::new));
    }

    public String getName() {
        return "PDE Target Platform State";
    }

    public String getLocation() {
        return "pde-target-state";
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return ResourceUtils.findProviders(requirements, this::findProvider);
    }

    public List<Capability> findProvider(Requirement requirement) {
        String namespace = requirement.getNamespace();
        return (List)TargetRepository.bundles(null).map(r -> new BundleDescriptionRepositoryResource((Repository)this, (BundleDescription)r)).flatMap(resource -> ResourceUtils.capabilityStream((Resource)resource, (String)namespace)).filter(ResourceUtils.matcher((Requirement)requirement, ResourceUtils::filterPredicate)).collect(ResourceUtils.toCapabilities());
    }

    private static Stream<BundleDescription> bundles(String bsn) {
        Optional<State> state = TargetRepository.getTargetPlatformState();
        if (state.isEmpty()) {
            return Stream.empty();
        }
        BundleDescription[] bundles = bsn == null ? state.get().getBundles() : state.get().getBundles(bsn);
        return Arrays.stream(bundles);
    }

    private static Optional<State> getTargetPlatformState() {
        PDECore pde = PDECore.getDefault();
        if (pde == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(pde.getModelManager().getState().getState());
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private static Version convert(aQute.bnd.version.Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    private static aQute.bnd.version.Version convert(Version v) {
        return new aQute.bnd.version.Version(v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
    }

    public static TargetRepository getTargetRepository() {
        return instance;
    }

    private static final class BundleDescriptionRepositoryResource
    implements RepositoryContent,
    Resource,
    IAdaptable {
        private BundleDescription bundle;
        private Repository repository;

        public BundleDescriptionRepositoryResource(Repository repository, BundleDescription bundle) {
            this.repository = repository;
            this.bundle = bundle;
        }

        public List<Capability> getCapabilities(String namespace) {
            String location = this.bundle.getLocation();
            if (location != null && (namespace == null || "osgi.content".equals(namespace))) {
                File file = new File(location);
                return Stream.concat(this.bundleRequirements(namespace), contentCapabilityMap.computeIfAbsent(file, f -> new ContentCapabilityCache((File)f, this)).capability()).toList();
            }
            return this.bundleRequirements(namespace).toList();
        }

        private Stream<Capability> bundleRequirements(String namespace) {
            return this.bundle.getCapabilities(namespace).stream().map(original -> new Capability((Capability)original){
                private final /* synthetic */ Capability val$original;
                {
                    this.val$original = capability;
                }

                public Resource getResource() {
                    return this;
                }

                public String getNamespace() {
                    return this.val$original.getNamespace();
                }

                public Map<String, String> getDirectives() {
                    return this.val$original.getDirectives();
                }

                public Map<String, Object> getAttributes() {
                    return this.val$original.getAttributes();
                }

                public String toString() {
                    return this.val$original.toString();
                }
            });
        }

        public List<Requirement> getRequirements(String namespace) {
            return this.bundle.getRequirements(namespace);
        }

        public InputStream getContent() {
            String location = this.bundle.getLocation();
            if (location != null) {
                try {
                    return new FileInputStream(location);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(new FileNotFoundException());
        }

        public <T> T getAdapter(Class<T> adapter) {
            Path path;
            File file;
            String location;
            if (adapter == BundleDescription.class) {
                return adapter.cast(this.bundle);
            }
            if (adapter == File.class && (location = this.bundle.getLocation()) != null && (file = new File(location)).isFile()) {
                return adapter.cast(file);
            }
            if (adapter == Path.class && (location = this.bundle.getLocation()) != null && Files.isRegularFile(path = Path.of(location, new String[0]), new LinkOption[0])) {
                return adapter.cast(path);
            }
            if (adapter == Repository.class) {
                return adapter.cast(this.repository);
            }
            return null;
        }
    }

    private static final class ContentCapabilityCache {
        private final File file;
        private Capability capability;
        private long lastLength;
        private long lastModified;
        private Resource resource;

        public ContentCapabilityCache(File file, Resource resource) {
            this.file = file;
            this.resource = resource;
        }

        public synchronized Stream<Capability> capability() {
            if (this.isOutDated()) {
                String sha;
                CapReqBuilder content = new CapReqBuilder(this.resource, "osgi.content");
                try {
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    if (this.file.isDirectory()) {
                        digest.update(this.file.getAbsolutePath().getBytes());
                    } else {
                        try {
                            Throwable throwable = null;
                            Object var5_8 = null;
                            try (DigestInputStream stream = new DigestInputStream(new FileInputStream(this.file), digest);){
                                stream.readAllBytes();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            return Stream.empty();
                        }
                    }
                    byte[] bytes = digest.digest();
                    sha = HexFormat.of().formatHex(bytes);
                }
                catch (NoSuchAlgorithmException e) {
                    return Stream.empty();
                }
                content.addAttribute("osgi.content", (Object)sha);
                content.addAttribute("size", (Object)this.file.length());
                content.addAttribute("mime", (Object)"application/vnd.osgi.bundle");
                try {
                    content.addAttribute("url", (Object)this.file.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    return Stream.empty();
                }
                this.capability = content.buildCapability();
            }
            return Stream.of(this.capability);
        }

        private boolean isOutDated() {
            if (this.file.isFile()) {
                long length = this.file.length();
                long modified = this.file.lastModified();
                if (length != this.lastLength || modified != this.lastModified) {
                    this.lastLength = length;
                    this.lastModified = modified;
                    return true;
                }
            }
            return this.capability == null;
        }
    }
}

