/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.pde.bnd.ui.Central;

public class RefreshFileJob
extends WorkspaceJob {
    private final boolean derived;
    private final List<File> files;

    public RefreshFileJob(File file, boolean derived) throws Exception {
        this(Collections.singletonList(file), derived);
    }

    public RefreshFileJob(List<File> filesToRefresh, boolean derived) {
        super("Refreshing files");
        this.derived = derived;
        this.files = filesToRefresh;
    }

    public boolean needsToSchedule() {
        return !this.files.isEmpty();
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)this.files.size());
        for (File file : this.files) {
            if (file != null) {
                Central.refreshFile(file, (IProgressMonitor)progress.split(1), this.derived);
                continue;
            }
            progress.worked(1);
        }
        progress.done();
        return Status.OK_STATUS;
    }
}

