/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.model.elements.DebugElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;

public class MemoryBlockLabelProvider
extends DebugElementLabelProvider {
    @Override
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof IMemoryBlock) {
            return this.getLabel((IMemoryBlock)element);
        }
        return super.getLabel(elementPath, presentationContext, columnId);
    }

    @Override
    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof IMemoryBlock) {
            return DebugPluginImages.getImageDescriptor("IMG_OBJS_VARIABLE");
        }
        return super.getImageDescriptor(elementPath, presentationContext, columnId);
    }

    private String getLabel(IMemoryBlock memoryBlock) {
        Object memoryBlockLabel = " ";
        if (memoryBlock instanceof IMemoryBlockExtension) {
            if (((IMemoryBlockExtension)memoryBlock).getExpression() != null) {
                memoryBlockLabel = (String)memoryBlockLabel + ((IMemoryBlockExtension)memoryBlock).getExpression();
            }
        } else {
            long address = memoryBlock.getStartAddress();
            memoryBlockLabel = Long.toHexString(address);
        }
        return memoryBlockLabel;
    }
}

