/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.SwarmCluster;
import org.mandas.docker.client.messages.swarm.SwarmSpec;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableSwarmCluster
implements SwarmCluster {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final SwarmSpec swarmSpec;

    private ImmutableSwarmCluster(String id, Version version, Date createdAt, Date updatedAt, SwarmSpec swarmSpec) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.swarmSpec = swarmSpec;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public SwarmSpec swarmSpec() {
        return this.swarmSpec;
    }

    public final ImmutableSwarmCluster withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableSwarmCluster(newValue, this.version, this.createdAt, this.updatedAt, this.swarmSpec);
    }

    public final ImmutableSwarmCluster withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableSwarmCluster(this.id, newValue, this.createdAt, this.updatedAt, this.swarmSpec);
    }

    public final ImmutableSwarmCluster withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableSwarmCluster(this.id, this.version, newValue, this.updatedAt, this.swarmSpec);
    }

    public final ImmutableSwarmCluster withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableSwarmCluster(this.id, this.version, this.createdAt, newValue, this.swarmSpec);
    }

    public final ImmutableSwarmCluster withSwarmSpec(SwarmSpec value) {
        if (this.swarmSpec == value) {
            return this;
        }
        SwarmSpec newValue = Objects.requireNonNull(value, "swarmSpec");
        return new ImmutableSwarmCluster(this.id, this.version, this.createdAt, this.updatedAt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwarmCluster && this.equalTo(0, (ImmutableSwarmCluster)another);
    }

    private boolean equalTo(int synthetic, ImmutableSwarmCluster another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.swarmSpec.equals(another.swarmSpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.swarmSpec.hashCode();
        return h;
    }

    public String toString() {
        return "SwarmCluster{id=" + this.id + ", version=" + String.valueOf(this.version) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", swarmSpec=" + String.valueOf(this.swarmSpec) + "}";
    }

    public static ImmutableSwarmCluster copyOf(SwarmCluster instance) {
        if (instance instanceof ImmutableSwarmCluster) {
            return (ImmutableSwarmCluster)instance;
        }
        return ImmutableSwarmCluster.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SWARM_SPEC = 16L;
        private long initBits = 31L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private SwarmSpec swarmSpec;

        private Builder() {
        }

        public final Builder from(SwarmCluster instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.swarmSpec(instance.swarmSpec());
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder swarmSpec(SwarmSpec swarmSpec) {
            this.swarmSpec = Objects.requireNonNull(swarmSpec, "swarmSpec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSwarmCluster build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSwarmCluster(this.id, this.version, this.createdAt, this.updatedAt, this.swarmSpec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("swarmSpec");
            }
            return "Cannot build SwarmCluster, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

