/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mandas.docker.client.LogMessage;

public class LogReader
implements Closeable {
    private final InputStream stream;
    public static final int HEADER_SIZE = 8;
    public static final int FRAME_SIZE_OFFSET = 4;

    public LogReader(InputStream stream) {
        this.stream = stream;
    }

    public LogMessage nextMessage() throws IOException {
        byte[] frame;
        this.stream.mark(8);
        byte[] headerBytes = new byte[8];
        int n = this.readAllBytes(headerBytes);
        if (n == 0) {
            return null;
        }
        ByteBuffer header = ByteBuffer.wrap(headerBytes);
        int streamId = header.get();
        int idZ = header.getInt(0);
        if (idZ == 0 || idZ == 0x1000000 || idZ == 0x2000000) {
            header.position(4);
            int frameSize = header.getInt();
            frame = new byte[frameSize];
        } else {
            this.stream.reset();
            streamId = LogMessage.Stream.STDOUT.id();
            frame = new byte[this.stream.available()];
        }
        int total = this.readAllBytes(frame);
        if (total < frame.length) {
            throw new EOFException("EOF before reading " + frame.length + " bytes. " + total + " read instead.");
        }
        return new LogMessage(streamId, ByteBuffer.wrap(frame));
    }

    private int readAllBytes(byte[] buf) throws IOException {
        int total;
        int result;
        for (total = 0; total < buf.length && (result = this.stream.read(buf, total, buf.length - total)) != -1; total += result) {
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

