/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class BaseImagesCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        final List<IDockerImage> selectedImages = CommandUtils.getSelectedImages(activePart);
        final IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (connection == null || selectedImages.isEmpty()) {
            Activator.log(new DockerException(CommandMessages.getString("Command.missing.selection.failure")));
            return null;
        }
        Job job = new Job(this.getJobName(selectedImages)){

            protected IStatus run(IProgressMonitor monitor) {
                if (BaseImagesCommandHandler.this.confirmed(selectedImages)) {
                    monitor.beginTask(BaseImagesCommandHandler.this.getJobName(selectedImages), selectedImages.size());
                    for (IDockerImage image : selectedImages) {
                        monitor.setTaskName(BaseImagesCommandHandler.this.getTaskName(image));
                        BaseImagesCommandHandler.this.executeInJob(image, connection);
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
        return null;
    }

    void openError(String errorMessage, Exception e) {
        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)errorMessage, (String)e.getMessage()));
    }

    boolean confirmed(List<IDockerImage> selectedImages) {
        return true;
    }

    abstract String getJobName(List<IDockerImage> var1);

    abstract String getTaskName(IDockerImage var1);

    abstract void executeInJob(IDockerImage var1, IDockerConnection var2);
}

