/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerEnvironmentVariableDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RunImageEnvironmentTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunEnvTab.name";
    private static final int COLUMNS = 3;
    private ImageRunResourceVolumesVariablesModel model = null;

    public RunImageEnvironmentTab(ImageRunResourceVolumesVariablesModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createEnvironmentVariablesContainer(container);
        }
        this.setControl((Control)container);
    }

    private void createEnvironmentVariablesContainer(Composite container) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)new Label(container, 0));
        Label envVarLabel = new Label(container, 0);
        envVarLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.envVarLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)envVarLabel);
        TableViewer environmentVariablesTableViewer = this.createEnvironmentVariablesTable(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(200, 100).applyTo((Control)environmentVariablesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.setEnabled(true);
        addButton.addSelectionListener(this.onAddEnvironmentVariable(environmentVariablesTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.setEnabled(true);
        editButton.addSelectionListener(this.onEditEnvironmentVariable(environmentVariablesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveEnvironmentVariables(environmentVariablesTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)environmentVariablesTableViewer, this.model.getEnvironmentVariables(), (IValueProperty[])BeanProperties.values(EnvironmentVariableModel.class, (String[])new String[]{"name", "value"}));
        environmentVariablesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                RunImageEnvironmentTab.setControlsEnabled((Control[])targetButtons, false);
            } else {
                RunImageEnvironmentTab.setControlsEnabled((Control[])targetButtons, true);
            }
            this.updateLaunchConfigurationDialog();
        };
    }

    private TableViewerColumn addTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private TableViewer createEnvironmentVariablesTable(Composite container) {
        Table table = new Table(container, 68352);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColumn(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.nameColumn"), 200);
        this.addTableViewerColumn(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.valueColumn"), 200);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private SelectionListener onAddEnvironmentVariable(TableViewer environmentVariablesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                this.model.getEnvironmentVariables().add((Object)dialog.getEnvironmentVariable());
                environmentVariablesTableViewer.add((Object)dialog.getEnvironmentVariable());
                environmentVariablesTableViewer.refresh();
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private SelectionListener onEditEnvironmentVariable(TableViewer environmentVariablesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            EnvironmentVariableModel selectedVariable = (EnvironmentVariableModel)environmentVariablesTableViewer.getStructuredSelection().getFirstElement();
            ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(this.getShell(), selectedVariable);
            dialog.create();
            if (dialog.open() == 0) {
                selectedVariable.setName(dialog.getEnvironmentVariable().getName());
                selectedVariable.setValue(dialog.getEnvironmentVariable().getValue());
                environmentVariablesTableViewer.refresh();
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private SelectionListener onRemoveEnvironmentVariables(TableViewer environmentVariablesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = environmentVariablesTableViewer.getStructuredSelection();
            for (EnvironmentVariableModel m : selection) {
                this.model.removeEnvironmentVariable(m);
                environmentVariablesTableViewer.remove((Object)m);
                environmentVariablesTableViewer.refresh();
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        for (Control control : controls) {
            control.setEnabled(enabled);
        }
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.environment_co.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            List environmentVariables = configuration.getAttribute("envVariables", new ArrayList());
            this.model.setEnvironmentVariables(environmentVariables);
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
        this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        ArrayList<String> envList = new ArrayList<String>();
        for (EnvironmentVariableModel m : this.model.getEnvironmentVariables()) {
            envList.add(m.toString());
        }
        configuration.setAttribute("envVariables", envList);
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageEnvironmentTab.this.updateLaunchConfigurationDialog();
        }
    }
}

