/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.Map;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.IDevhelpContentHandler;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;
import org.xml.sax.Attributes;

public class DevhelpContentHandler
implements IDevhelpContentHandler {
    private boolean begin;
    private boolean returnType;
    private boolean protoStart;
    private boolean parmStart;
    private boolean descStart;
    private boolean rowIgnore;
    private boolean srcLink;
    private boolean valid = true;
    private Map<String, String> funcs;
    private String returnValue;
    private String funcName;
    private String rowTag;
    private StringBuilder prototype = new StringBuilder();
    private StringBuilder description = new StringBuilder();
    private int divCounter;
    private int rowItemCount;
    private DevHelpSAXParser htmlsaxParser;

    public DevhelpContentHandler(Map<String, String> funcs) {
        this.funcs = funcs;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) {
        String classValue;
        if ("A".equals(localName) && (classValue = a.getValue("class")) != null) {
            if (classValue.equals("anchor")) {
                String href = a.getValue("href");
                if (href != null) {
                    if (href.equals("#declaration")) {
                        String mapName = this.funcs.get("name");
                        if (mapName != null) {
                            this.funcName = mapName.trim();
                            if (this.funcName.endsWith("()")) {
                                this.funcName = this.funcName.replaceAll("\\(\\)", "").replaceAll("\\p{javaSpaceChar}", "");
                            }
                            this.begin = true;
                        }
                    } else if (href.equals("#description")) {
                        this.descStart = true;
                    } else if (href.equals("#return-value")) {
                        this.descStart = true;
                    } else if (href.equals("#parameters")) {
                        this.description.append("<br><br><h4>Parameters:</h4>");
                        this.descStart = true;
                    }
                }
            } else if (classValue.equals("srclink")) {
                this.srcLink = true;
            }
        }
        if (this.begin) {
            String type;
            if ("DIV".equals(localName)) {
                ++this.divCounter;
            }
            if (!this.descStart && "SPAN".equals(localName)) {
                type = a.getValue("class");
                if (this.returnValue == null && type != null && type.equals("n")) {
                    this.returnType = true;
                }
            }
            if (this.protoStart) {
                if ("P".equals(localName)) {
                    this.protoStart = false;
                    this.descStart = true;
                    this.description.append("<p>");
                }
            } else if (this.descStart) {
                if ("P".equals(localName)) {
                    this.description.append("<p>");
                } else if ("TABLE".equals(localName)) {
                    this.description.append("<dl>");
                } else if ("TR".equals(localName)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(localName)) {
                    type = a.getValue("class");
                    if (type != null && type.equals("listing_lines")) {
                        this.rowIgnore = true;
                    } else {
                        this.rowIgnore = false;
                        this.rowTag = this.rowItemCount++ == 0 ? "<dt>" : "<dd>";
                        this.description.append(this.rowTag);
                    }
                } else if ("H4".equals(localName)) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.srcLink) {
            if ("A".equals(localName)) {
                this.srcLink = false;
            }
        } else if (this.begin) {
            if ("DIV".equals(localName)) {
                --this.divCounter;
                if (this.divCounter <= 0) {
                    this.descStart = false;
                    this.parmStart = false;
                    this.protoStart = false;
                }
            } else if ("SECTION".equals(localName) && this.valid && this.returnValue != null && !this.returnValue.startsWith("#") && !this.returnValue.startsWith("typedef ")) {
                FunctionInfo info = new FunctionInfo(this.funcName);
                info.setReturnType(this.returnValue);
                info.setPrototype(this.prototype.toString());
                info.setDescription(this.description.toString());
                this.htmlsaxParser.getFunctionInfos().put(this.funcName, info);
                throw new FuncFoundSaxException();
            }
            if (this.descStart) {
                if ("P".equals(localName)) {
                    this.description.append("</p>");
                } else if ("TABLE".equals(localName)) {
                    this.description.append("</dl>");
                } else if ("TR".equals(localName)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(localName)) {
                    if (!this.rowIgnore) {
                        if (this.rowTag != null && this.rowTag.equals("<dt>")) {
                            this.description.append("</dt>");
                        } else {
                            this.description.append("</dd>");
                        }
                    }
                    this.rowIgnore = false;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.begin && !this.srcLink) {
            if (this.returnType) {
                this.returnValue = "";
                String tmp = new String(ch).trim();
                boolean completed = false;
                if (tmp.endsWith(");")) {
                    completed = true;
                    tmp = tmp.substring(0, tmp.length() - 2);
                }
                String[] tokens = tmp.split("\\s+");
                String separator = "";
                this.protoStart = true;
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.equals(this.funcName)) {
                        separator = "";
                        for (int j = i + 1; j < tokens.length; ++j) {
                            String jtoken = tokens[j];
                            if (j == i + 1 && jtoken.charAt(0) == '(') {
                                jtoken = jtoken.substring(1);
                                this.parmStart = true;
                                this.protoStart = false;
                            }
                            this.prototype.append(separator).append(jtoken);
                            separator = " ";
                        }
                        if (!this.parmStart || !completed) break;
                        this.parmStart = false;
                        this.descStart = true;
                        break;
                    }
                    this.returnValue = this.returnValue + separator + token;
                    separator = " ";
                }
                this.returnType = false;
            } else if (this.protoStart) {
                String temp = new String(ch).trim();
                boolean completed = false;
                if (temp.endsWith(");")) {
                    completed = true;
                    temp = temp.substring(0, temp.length() - 2);
                }
                String separator = " ";
                while (temp.startsWith("*") || temp.startsWith("const")) {
                    if (temp.charAt(0) == '*') {
                        this.returnValue = this.returnValue + separator + "*";
                        temp = temp.substring(1).trim();
                        separator = "";
                        continue;
                    }
                    this.returnValue = this.returnValue + "const";
                    temp = temp.substring(5).trim();
                    separator = " ";
                }
                int index = temp.lastIndexOf(40);
                int index2 = temp.lastIndexOf(41);
                if (index2 < index) {
                    if (index + 1 < temp.length()) {
                        temp = temp.substring(index + 1).trim();
                        this.prototype.append(temp);
                    }
                    this.parmStart = true;
                    this.protoStart = false;
                }
                if (this.parmStart && completed) {
                    this.parmStart = false;
                    this.descStart = true;
                }
            } else if (this.parmStart) {
                Object parmData = new String(ch).trim();
                int index = ((String)parmData).indexOf(41);
                if (index >= 0) {
                    this.parmStart = false;
                    this.descStart = true;
                    parmData = ((String)parmData).substring(0, index);
                }
                if (this.prototype.length() == 0 && !((String)parmData).equals(",") && !((String)parmData).isEmpty()) {
                    parmData = " " + (String)parmData;
                }
                this.prototype.append((String)parmData);
            } else if (this.descStart && !this.rowIgnore) {
                this.description.append(String.valueOf(ch));
            }
        }
    }

    public String toString() {
        return "funcName: <" + this.funcName + "> returnType: <" + this.returnValue + "> prototype: <" + String.valueOf(this.prototype) + "> description: " + String.valueOf(this.description);
    }

    @Override
    public void setHtmlsaxParser(DevHelpSAXParser htmlsaxParser) {
        this.htmlsaxParser = htmlsaxParser;
    }
}

