/**
 */
package org.eclipse.lsat.common.mpt.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.lsat.common.mpt.util.MPTAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MPTItemProviderAdapterFactory extends MPTAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MPTItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.Matrix} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MatrixItemProvider matrixItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.Matrix}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMatrixAdapter() {
		if (matrixItemProvider == null) {
			matrixItemProvider = new MatrixItemProvider(this);
		}

		return matrixItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MaxPlusSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaxPlusSpecificationItemProvider maxPlusSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MaxPlusSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaxPlusSpecificationAdapter() {
		if (maxPlusSpecificationItemProvider == null) {
			maxPlusSpecificationItemProvider = new MaxPlusSpecificationItemProvider(this);
		}

		return maxPlusSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.FSM} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FSMItemProvider fsmItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.FSM}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFSMAdapter() {
		if (fsmItemProvider == null) {
			fsmItemProvider = new FSMItemProvider(this);
		}

		return fsmItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.FSMState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FSMStateItemProvider fsmStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.FSMState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFSMStateAdapter() {
		if (fsmStateItemProvider == null) {
			fsmStateItemProvider = new FSMStateItemProvider(this);
		}

		return fsmStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.FSMTransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FSMTransitionItemProvider fsmTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.FSMTransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFSMTransitionAdapter() {
		if (fsmTransitionItemProvider == null) {
			fsmTransitionItemProvider = new FSMTransitionItemProvider(this);
		}

		return fsmTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPSItemProvider mpsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPSAdapter() {
		if (mpsItemProvider == null) {
			mpsItemProvider = new MPSItemProvider(this);
		}

		return mpsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPSConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPSConfigurationItemProvider mpsConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPSConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPSConfigurationAdapter() {
		if (mpsConfigurationItemProvider == null) {
			mpsConfigurationItemProvider = new MPSConfigurationItemProvider(this);
		}

		return mpsConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPSTransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPSTransitionItemProvider mpsTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPSTransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPSTransitionAdapter() {
		if (mpsTransitionItemProvider == null) {
			mpsTransitionItemProvider = new MPSTransitionItemProvider(this);
		}

		return mpsTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPA} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPAItemProvider mpaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPA}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPAAdapter() {
		if (mpaItemProvider == null) {
			mpaItemProvider = new MPAItemProvider(this);
		}

		return mpaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPAState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPAStateItemProvider mpaStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPAState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPAStateAdapter() {
		if (mpaStateItemProvider == null) {
			mpaStateItemProvider = new MPAStateItemProvider(this);
		}

		return mpaStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.MPATransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MPATransitionItemProvider mpaTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.MPATransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMPATransitionAdapter() {
		if (mpaTransitionItemProvider == null) {
			mpaTransitionItemProvider = new MPATransitionItemProvider(this);
		}

		return mpaTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.RowVector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RowVectorItemProvider rowVectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.RowVector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRowVectorAdapter() {
		if (rowVectorItemProvider == null) {
			rowVectorItemProvider = new RowVectorItemProvider(this);
		}

		return rowVectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.ColumnVector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColumnVectorItemProvider columnVectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.ColumnVector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createColumnVectorAdapter() {
		if (columnVectorItemProvider == null) {
			columnVectorItemProvider = new ColumnVectorItemProvider(this);
		}

		return columnVectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.lsat.common.mpt.Event} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventItemProvider eventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.lsat.common.mpt.Event}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventAdapter() {
		if (eventItemProvider == null) {
			eventItemProvider = new EventItemProvider(this);
		}

		return eventItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (matrixItemProvider != null) matrixItemProvider.dispose();
		if (maxPlusSpecificationItemProvider != null) maxPlusSpecificationItemProvider.dispose();
		if (fsmItemProvider != null) fsmItemProvider.dispose();
		if (fsmStateItemProvider != null) fsmStateItemProvider.dispose();
		if (fsmTransitionItemProvider != null) fsmTransitionItemProvider.dispose();
		if (mpsItemProvider != null) mpsItemProvider.dispose();
		if (mpsConfigurationItemProvider != null) mpsConfigurationItemProvider.dispose();
		if (mpsTransitionItemProvider != null) mpsTransitionItemProvider.dispose();
		if (mpaItemProvider != null) mpaItemProvider.dispose();
		if (mpaStateItemProvider != null) mpaStateItemProvider.dispose();
		if (mpaTransitionItemProvider != null) mpaTransitionItemProvider.dispose();
		if (rowVectorItemProvider != null) rowVectorItemProvider.dispose();
		if (columnVectorItemProvider != null) columnVectorItemProvider.dispose();
		if (eventItemProvider != null) eventItemProvider.dispose();
	}

}
