/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ElementTreeSelectionWizardPage
extends WizardPage {
    private final List<ViewerFilter> fFilters = new ArrayList<ViewerFilter>(4);
    private final IBaseLabelProvider fLabelProvider;
    private final ITreeContentProvider fContentProvider;
    private TreeViewer fViewer;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator = null;
    private boolean fAllowMultiple = true;
    private Object fInput = null;
    private Object[] fResult;
    private Object[] fInitialSelection;
    private int fWidth = 60;
    private int fHeight = 18;

    public ElementTreeSelectionWizardPage(String pageName, IBaseLabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(pageName);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        int style = 0x800 | (this.fAllowMultiple ? 2 : 4);
        this.fViewer = new TreeViewer(composite, style);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        this.fViewer.getTree().setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider(this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementTreeSelectionWizardPage.this.setResult(((IStructuredSelection)event.getSelection()).toList());
                ElementTreeSelectionWizardPage.this.updateNextStatus();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        for (ViewerFilter filter : this.fFilters) {
            this.fViewer.addFilter(filter);
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeSelectionWizardPage.this.updateNextStatus();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ElementTreeSelectionWizardPage.this.fViewer.getExpandedState(item)) {
                        ElementTreeSelectionWizardPage.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        ElementTreeSelectionWizardPage.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.fViewer.setInput(this.fInput);
        if (this.fInitialSelection != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(this.fInitialSelection), true);
        }
        this.setControl((Control)composite);
    }

    public void addFilter(ViewerFilter filter) {
        this.fFilters.add(filter);
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.fAllowMultiple = allowMultiple;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void setInitialSelections(Collection<?> initialSelection) {
        this.fInitialSelection = initialSelection.toArray();
    }

    public void setInitialSelections(Object ... initialSelection) {
        this.fInitialSelection = initialSelection;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    protected void setResult(Collection<?> result) {
        this.fResult = result.toArray();
    }

    protected void setSelectionResult(Object ... result) {
        this.fResult = result;
    }

    protected void updateNextStatus() {
        IStatus status = this.fValidator == null ? Status.OK_STATUS : this.fValidator.validate(this.getResult());
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                this.setMessage(status.getMessage());
            }
            case 0: {
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            default: {
                this.setErrorMessage(status.getMessage());
                this.setPageComplete(false);
            }
        }
    }
}

