/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algebra;

import java.util.Arrays;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;

public class Vector
implements Comparable<Vector> {
    private Value[] vector;

    public Vector(Integer length, Value value) {
        this.vector = new Value[length.intValue()];
        int i = 0;
        while (i < length) {
            this.put(i, value);
            ++i;
        }
    }

    public Vector(Vector otherVector) {
        this.vector = new Value[otherVector.size().intValue()];
        int i = 0;
        while (i < this.vector.length) {
            this.put(i, otherVector.get(i));
            ++i;
        }
    }

    public Vector(Double ... values) {
        this.vector = new Value[values.length];
        int i = 0;
        while (i < values.length) {
            this.put(i, new Value(values[i]));
            ++i;
        }
    }

    public Vector(Value ... values) {
        this.vector = new Value[values.length];
        int i = 0;
        while (i < values.length) {
            this.put(i, values[i]);
            ++i;
        }
    }

    public Vector(Integer length) {
        this.vector = new Value[length.intValue()];
    }

    public void put(Integer index, Value mpValue) {
        this.vector[index.intValue()] = mpValue;
    }

    public Integer size() {
        return this.vector.length;
    }

    public Value get(Integer index) {
        return this.vector[index];
    }

    public Value getNorm() {
        Value norm = Value.NEGATIVE_INFINITY;
        Value[] valueArray = this.vector;
        int n = this.vector.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            norm = norm.max(v);
            ++n2;
        }
        return norm;
    }

    public Vector normalize() {
        Value maximalElement = this.getNorm();
        assert (!maximalElement.equals(Value.NEGATIVE_INFINITY));
        Vector result = new Vector(this.size());
        int i = 0;
        while (i < this.size()) {
            result.put(i, this.get(i).subtract(maximalElement));
            ++i;
        }
        return result;
    }

    public Vector plus(Value value) {
        Vector vec = new Vector(this.size());
        int i = 0;
        while (i < this.size()) {
            vec.put(i, this.vector[i].add(value));
            ++i;
        }
        return vec;
    }

    public Vector max(Vector mpVector) {
        assert (mpVector.size().equals(this.size()));
        Vector vec = new Vector(this.size());
        int i = 0;
        while (i < mpVector.size()) {
            vec.put(i, mpVector.get(i).max(this.get(i)));
            ++i;
        }
        return vec;
    }

    @Override
    public int compareTo(Vector mpVector) {
        assert (mpVector.size().equals(this.size()));
        int i = 0;
        while (i < mpVector.size()) {
            int comparison = this.vector[i].compareTo(mpVector.get(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector vector1 = (Vector)o;
        return Arrays.equals(this.vector, vector1.vector);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vector);
    }

    public String toString() {
        return Arrays.toString(this.vector);
    }
}

