/*
 * Decompiled with CFR 0.152.
 */
package timing.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import timing.Array;
import timing.CalculationMode;
import timing.EnumeratedDistribution;
import timing.FixedValue;
import timing.NormalDistribution;
import timing.PertDistribution;
import timing.TimingFactory;
import timing.TimingPackage;
import timing.TriangularDistribution;
import timing.impl.ArrayImpl;
import timing.impl.EnumeratedDistributionImpl;
import timing.impl.FixedValueImpl;
import timing.impl.NormalDistributionImpl;
import timing.impl.PertDistributionImpl;
import timing.impl.TriangularDistributionImpl;

public class TimingFactoryImpl
extends EFactoryImpl
implements TimingFactory {
    public static TimingFactory init() {
        try {
            TimingFactory theTimingFactory = (TimingFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/lsat/timing");
            if (theTimingFactory != null) {
                return theTimingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TimingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createFixedValue();
            }
            case 2: {
                return this.createArray();
            }
            case 3: {
                return this.createTriangularDistribution();
            }
            case 5: {
                return this.createPertDistribution();
            }
            case 6: {
                return this.createNormalDistribution();
            }
            case 7: {
                return this.createEnumeratedDistribution();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createCalculationModeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertCalculationModeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public FixedValue createFixedValue() {
        FixedValueImpl fixedValue = new FixedValueImpl();
        return fixedValue;
    }

    @Override
    public Array createArray() {
        ArrayImpl array = new ArrayImpl();
        return array;
    }

    @Override
    public TriangularDistribution createTriangularDistribution() {
        TriangularDistributionImpl triangularDistribution = new TriangularDistributionImpl();
        return triangularDistribution;
    }

    @Override
    public PertDistribution createPertDistribution() {
        PertDistributionImpl pertDistribution = new PertDistributionImpl();
        return pertDistribution;
    }

    @Override
    public NormalDistribution createNormalDistribution() {
        NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
        return normalDistribution;
    }

    @Override
    public EnumeratedDistribution createEnumeratedDistribution() {
        EnumeratedDistributionImpl enumeratedDistribution = new EnumeratedDistributionImpl();
        return enumeratedDistribution;
    }

    public CalculationMode createCalculationModeFromString(EDataType eDataType, String initialValue) {
        CalculationMode result = CalculationMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCalculationModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public TimingPackage getTimingPackage() {
        return (TimingPackage)this.getEPackage();
    }

    @Deprecated
    public static TimingPackage getPackage() {
        return TimingPackage.eINSTANCE;
    }
}

