/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.lsat.common.emf.common.util.DiagnosticException;
import org.eclipse.lsat.common.emf.common.util.DiagnosticUtil;
import org.eclipse.lsat.common.qvto.util.ExecutionDiagnosticException;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.common.qvto.util.internal.Log4Slf4jLog;
import org.eclipse.lsat.common.qvto.util.internal.TraceTransformatorExecutor;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractModelTransformer<Input, Output> {
    public static final String QVT_MARKER_STR = "QVTORunner";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HashMap<String, Object> itsConfigProperties = new HashMap();
    private TraceTransformatorExecutor itsExecutor = null;
    protected IProgressMonitor itsMonitor = null;

    static {
        URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore"), URI.createURI((String)"no-such-protocol:/this/does/not/exist"));
    }

    public void setConfigProperty(String aName, Object aValue) {
        this.itsConfigProperties.put(aName, aValue);
    }

    public void setTraceURI(URI aTraceURI) {
        this.getExecutor().setTraceURI(aTraceURI);
    }

    protected void registerImportedUnits() throws QvtoTransformationException {
    }

    protected final void registerImportedUnit(String unit) throws QvtoTransformationException {
        URL unitURL = this.getClass().getResource(unit);
        if (unitURL == null) {
            throw new QvtoTransformationException("Imported unit could not be found in classpath, unit:" + unit);
        }
        URI unitURI = URI.createURI((String)unitURL.toString());
        URI tformationURI = this.getTransformationURI();
        URI baseURI = tformationURI.trimSegments(1);
        URI resolvedUnitURI = baseURI.appendSegments(URI.createURI((String)unit).segments());
        URIConverter.URI_MAP.put(resolvedUnitURI, unitURI);
    }

    protected void execute(ModelExtent ... aModelParameters) throws QvtoTransformationException {
        Log4Slf4jLog omlLogger = new Log4Slf4jLog(LoggerFactory.getLogger((String)(this.logger.getName() + ".qvto")));
        this.registerImportedUnits();
        ExecutionDiagnostic diagnostic = this.getExecutor().execute(this.createExecutionContext(omlLogger, this.itsMonitor), aModelParameters);
        DiagnosticUtil.logFull((Diagnostic)diagnostic, (Logger)this.logger);
        if (diagnostic.getCode() == 100 && omlLogger.hasLastMessage() && omlLogger.getLastMessage().isAssert()) {
            throw new QvtoTransformationException(omlLogger.getLastMessage().getMessage(), (Throwable)((Object)new ExecutionDiagnosticException(diagnostic)));
        }
        if (diagnostic.getSeverity() >= 4) {
            throw new QvtoTransformationException((Throwable)((Object)new ExecutionDiagnosticException(diagnostic)));
        }
    }

    protected void doValidate(EObject eObject) throws QvtoTransformationException {
        Diagnostic diagnostic = new Diagnostician().validate(eObject);
        DiagnosticUtil.logFull((Diagnostic)diagnostic, (Logger)this.logger);
        if (diagnostic.getSeverity() >= 2) {
            throw new QvtoTransformationException((Throwable)new DiagnosticException(diagnostic));
        }
    }

    protected abstract String getDefaultTransformation();

    protected URI getTransformationURI() {
        String defaultTransformation = this.getDefaultTransformation();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            URL url = this.getClass().getResource(defaultTransformation);
            return URI.createURI((String)url.toString());
        }
        return URI.createPlatformPluginURI((String)(bundle.getSymbolicName() + defaultTransformation), (boolean)true);
    }

    protected TraceTransformatorExecutor getExecutor() {
        if (this.itsExecutor != null) {
            return this.itsExecutor;
        }
        URI transformationURI = this.getTransformationURI();
        this.logger.debug("Loading transformation: " + String.valueOf(transformationURI));
        this.itsExecutor = new TraceTransformatorExecutor(transformationURI);
        return this.itsExecutor;
    }

    protected ExecutionContext createExecutionContext(Log aLogger, IProgressMonitor monitor) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        if (monitor != null) {
            context.setProgressMonitor(monitor);
        }
        context.setLog(aLogger);
        for (Map.Entry<String, Object> property : this.itsConfigProperties.entrySet()) {
            context.setConfigProperty(property.getKey(), property.getValue());
        }
        return context;
    }

    public final synchronized Output transformModel(Input input, IProgressMonitor monitor) throws QvtoTransformationException {
        Marker qvtMarker = MarkerFactory.getMarker((String)QVT_MARKER_STR);
        this.itsMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.logger.debug(qvtMarker, "Starting transformation");
        Output output = this.doTransformModel(input);
        this.logger.debug(qvtMarker, "Finished transformation");
        return output;
    }

    protected abstract Output doTransformModel(Input var1) throws QvtoTransformationException;

    protected <T extends EObject> List<T> validateMinMax(Class<T> type, ModelExtent modelExtent, int minCount, int maxCount) throws QvtoTransformationException {
        List<T> result = this.validateMany(type, modelExtent);
        if (result.size() < minCount) {
            throw new QvtoTransformationException("Expected at least " + minCount + " " + type.getSimpleName() + ": " + String.valueOf(result));
        }
        if (result.size() > maxCount) {
            throw new QvtoTransformationException("Expected at most " + maxCount + " " + type.getSimpleName() + ": " + String.valueOf(result));
        }
        return result;
    }

    protected <T extends EObject> T validateAtMostOne(Class<T> type, ModelExtent modelExtent) throws QvtoTransformationException {
        List<T> result = this.validateMinMax(type, modelExtent, 0, 1);
        return (T)(result.isEmpty() ? null : (EObject)result.get(0));
    }

    protected <T extends EObject> List<T> validateAtLeastOne(Class<T> type, ModelExtent modelExtent) throws QvtoTransformationException {
        List<T> result = this.validateMinMax(type, modelExtent, 1, Integer.MAX_VALUE);
        return result;
    }

    protected <T extends EObject> T validateOneAndOnlyOne(Class<T> type, ModelExtent modelExtent) throws QvtoTransformationException {
        List<T> result = this.validateMinMax(type, modelExtent, 1, 1);
        return (T)((EObject)result.get(0));
    }

    protected <T extends EObject> List<T> validateMany(Class<T> type, ModelExtent modelExtent) throws QvtoTransformationException {
        List result = modelExtent.getContents();
        for (EObject object : result) {
            if (type.isInstance(object)) continue;
            throw new QvtoTransformationException("Unexpected model extend content: " + String.valueOf(result));
        }
        return result;
    }
}

