/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalDispatching;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.dispatching.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.dispatching.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.dispatching.teditor.services.DispatchingGrammarAccess;

}

@parser::members {

 	private DispatchingGrammarAccess grammarAccess;

    public InternalDispatchingParser(TokenStream input, DispatchingGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "ActivityDispatching";
   	}

   	@Override
   	protected DispatchingGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleActivityDispatching
entryRuleActivityDispatching returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActivityDispatchingRule()); }
	iv_ruleActivityDispatching=ruleActivityDispatching
	{ $current=$iv_ruleActivityDispatching.current; }
	EOF;

// Rule ActivityDispatching
ruleActivityDispatching returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActivityDispatchingAccess().getActivityDispatchingAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityDispatchingAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityDispatchingRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_2='throughput'
			{
				newLeafNode(otherlv_2, grammarAccess.getActivityDispatchingAccess().getThroughputKeyword_2_0());
			}
			otherlv_3='{'
			{
				newLeafNode(otherlv_3, grammarAccess.getActivityDispatchingAccess().getLeftCurlyBracketKeyword_2_1());
			}
			(
				otherlv_4='iterations'
				{
					newLeafNode(otherlv_4, grammarAccess.getActivityDispatchingAccess().getIterationsKeyword_2_2_0());
				}
				otherlv_5=':'
				{
					newLeafNode(otherlv_5, grammarAccess.getActivityDispatchingAccess().getColonKeyword_2_2_1());
				}
				(
					(
						lv_numberOfIterations_6_0=RULE_INT
						{
							newLeafNode(lv_numberOfIterations_6_0, grammarAccess.getActivityDispatchingAccess().getNumberOfIterationsINTTerminalRuleCall_2_2_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getActivityDispatchingRule());
							}
							setWithLastConsumed(
								$current,
								"numberOfIterations",
								lv_numberOfIterations_6_0,
								"org.eclipse.xtext.common.Terminals.INT");
						}
					)
				)
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getActivityDispatchingAccess().getResourceIterationsResourceIterationsMapEntryParserRuleCall_2_3_0());
					}
					lv_resourceIterations_7_0=ruleResourceIterationsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivityDispatchingRule());
						}
						add(
							$current,
							"resourceIterations",
							lv_resourceIterations_7_0,
							"org.eclipse.lsat.dispatching.teditor.Dispatching.ResourceIterationsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getActivityDispatchingAccess().getRightCurlyBracketKeyword_2_4());
			}
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityDispatchingAccess().getDispatchGroupsDispatchGroupParserRuleCall_3_0());
				}
				lv_dispatchGroups_9_0=ruleDispatchGroup
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityDispatchingRule());
					}
					add(
						$current,
						"dispatchGroups",
						lv_dispatchGroups_9_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.DispatchGroup");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleResourceIterationsMapEntry
entryRuleResourceIterationsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceIterationsMapEntryRule()); }
	iv_ruleResourceIterationsMapEntry=ruleResourceIterationsMapEntry
	{ $current=$iv_ruleResourceIterationsMapEntry.current; }
	EOF;

// Rule ResourceIterationsMapEntry
ruleResourceIterationsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='iterations'
		{
			newLeafNode(otherlv_0, grammarAccess.getResourceIterationsMapEntryAccess().getIterationsKeyword_0());
		}
		otherlv_1='.'
		{
			newLeafNode(otherlv_1, grammarAccess.getResourceIterationsMapEntryAccess().getFullStopKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceIterationsMapEntryRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getResourceIterationsMapEntryAccess().getKeyIResourceCrossReference_2_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=':'
		{
			newLeafNode(otherlv_3, grammarAccess.getResourceIterationsMapEntryAccess().getColonKeyword_3());
		}
		(
			(
				lv_value_4_0=RULE_INT
				{
					newLeafNode(lv_value_4_0, grammarAccess.getResourceIterationsMapEntryAccess().getValueINTTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceIterationsMapEntryRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_4_0,
						"org.eclipse.xtext.common.Terminals.INT");
				}
			)
		)
	)
;

// Entry rule entryRuleDispatchGroup
entryRuleDispatchGroup returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDispatchGroupRule()); }
	iv_ruleDispatchGroup=ruleDispatchGroup
	{ $current=$iv_ruleDispatchGroup.current; }
	EOF;

// Rule DispatchGroup
ruleDispatchGroup returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDispatchGroupAccess().getDispatchGroupAction_0(),
					$current);
			}
		)
		otherlv_1='activities'
		{
			newLeafNode(otherlv_1, grammarAccess.getDispatchGroupAccess().getActivitiesKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDispatchGroupAccess().getNameIDStringParserRuleCall_2_0());
				}
				lv_name_2_0=ruleIDString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
					}
					set(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.IDString");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			otherlv_3='('
			{
				newLeafNode(otherlv_3, grammarAccess.getDispatchGroupAccess().getLeftParenthesisKeyword_3_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getDispatchGroupAccess().getUserAttributesAttributesMapEntryParserRuleCall_3_1_0_0());
						}
						lv_userAttributes_4_0=ruleAttributesMapEntry
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
							}
							add(
								$current,
								"userAttributes",
								lv_userAttributes_4_0,
								"org.eclipse.lsat.dispatching.teditor.Dispatching.AttributesMapEntry");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_5=','
					{
						newLeafNode(otherlv_5, grammarAccess.getDispatchGroupAccess().getCommaKeyword_3_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getDispatchGroupAccess().getUserAttributesAttributesMapEntryParserRuleCall_3_1_1_1_0());
							}
							lv_userAttributes_6_0=ruleAttributesMapEntry
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
								}
								add(
									$current,
									"userAttributes",
									lv_userAttributes_6_0,
									"org.eclipse.lsat.dispatching.teditor.Dispatching.AttributesMapEntry");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_7=')'
			{
				newLeafNode(otherlv_7, grammarAccess.getDispatchGroupAccess().getRightParenthesisKeyword_3_2());
			}
		)?
		(
			otherlv_8='repeat'
			{
				newLeafNode(otherlv_8, grammarAccess.getDispatchGroupAccess().getRepeatKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDispatchGroupAccess().getIteratorNameIDStringParserRuleCall_4_1_0());
					}
					lv_iteratorName_9_0=ruleIDString
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
						}
						set(
							$current,
							"iteratorName",
							lv_iteratorName_9_0,
							"org.eclipse.lsat.dispatching.teditor.Dispatching.IDString");
						afterParserOrEnumRuleCall();
					}
				)
			)?
			otherlv_10=':'
			{
				newLeafNode(otherlv_10, grammarAccess.getDispatchGroupAccess().getColonKeyword_4_2());
			}
			(
				(
					((
						ruleNumberRepeats
					)
					)=>
					(
						{
							newCompositeNode(grammarAccess.getDispatchGroupAccess().getRepeatsNumberRepeatsParserRuleCall_4_3_0_0());
						}
						lv_repeats_11_0=ruleNumberRepeats
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
							}
							add(
								$current,
								"repeats",
								lv_repeats_11_0,
								"org.eclipse.lsat.dispatching.teditor.Dispatching.NumberRepeats");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					otherlv_12='['
					{
						newLeafNode(otherlv_12, grammarAccess.getDispatchGroupAccess().getLeftSquareBracketKeyword_4_3_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getDispatchGroupAccess().getRepeatsRangeParserRuleCall_4_3_1_1_0());
							}
							lv_repeats_13_0=ruleRange
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
								}
								add(
									$current,
									"repeats",
									lv_repeats_13_0,
									"org.eclipse.lsat.dispatching.teditor.Dispatching.Range");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_14=','
						{
							newLeafNode(otherlv_14, grammarAccess.getDispatchGroupAccess().getCommaKeyword_4_3_1_2_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getDispatchGroupAccess().getRepeatsRangeParserRuleCall_4_3_1_2_1_0());
								}
								lv_repeats_15_0=ruleRange
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
									}
									add(
										$current,
										"repeats",
										lv_repeats_15_0,
										"org.eclipse.lsat.dispatching.teditor.Dispatching.Range");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_16=']'
					{
						newLeafNode(otherlv_16, grammarAccess.getDispatchGroupAccess().getRightSquareBracketKeyword_4_3_1_3());
					}
				)
			)
		)?
		otherlv_17='{'
		{
			newLeafNode(otherlv_17, grammarAccess.getDispatchGroupAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			otherlv_18='yield'
			{
				newLeafNode(otherlv_18, grammarAccess.getDispatchGroupAccess().getYieldKeyword_6_0());
			}
			otherlv_19=':'
			{
				newLeafNode(otherlv_19, grammarAccess.getDispatchGroupAccess().getColonKeyword_6_1());
			}
			(
				(
					lv_yield_20_0=RULE_INT
					{
						newLeafNode(lv_yield_20_0, grammarAccess.getDispatchGroupAccess().getYieldINTTerminalRuleCall_6_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDispatchGroupRule());
						}
						setWithLastConsumed(
							$current,
							"yield",
							lv_yield_20_0,
							"org.eclipse.xtext.common.Terminals.INT");
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getDispatchGroupAccess().getResourceYieldResourceYieldMapEntryParserRuleCall_7_0());
				}
				lv_resourceYield_21_0=ruleResourceYieldMapEntry
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
					}
					add(
						$current,
						"resourceYield",
						lv_resourceYield_21_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.ResourceYieldMapEntry");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_22='offset'
			{
				newLeafNode(otherlv_22, grammarAccess.getDispatchGroupAccess().getOffsetKeyword_8_0());
			}
			otherlv_23=':'
			{
				newLeafNode(otherlv_23, grammarAccess.getDispatchGroupAccess().getColonKeyword_8_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDispatchGroupAccess().getOffsetEBigDecimalParserRuleCall_8_2_0());
					}
					lv_offset_24_0=ruleEBigDecimal
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
						}
						set(
							$current,
							"offset",
							lv_offset_24_0,
							"org.eclipse.lsat.dispatching.teditor.Dispatching.EBigDecimal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getDispatchGroupAccess().getDispatchesDispatchParserRuleCall_9_0());
				}
				lv_dispatches_25_0=ruleDispatch
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDispatchGroupRule());
					}
					add(
						$current,
						"dispatches",
						lv_dispatches_25_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.Dispatch");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_26='}'
		{
			newLeafNode(otherlv_26, grammarAccess.getDispatchGroupAccess().getRightCurlyBracketKeyword_10());
		}
	)
;

// Entry rule entryRuleNumberRepeats
entryRuleNumberRepeats returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumberRepeatsRule()); }
	iv_ruleNumberRepeats=ruleNumberRepeats
	{ $current=$iv_ruleNumberRepeats.current; }
	EOF;

// Rule NumberRepeats
ruleNumberRepeats returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getNumberRepeatsAccess().getRepeatAction_0(),
					$current);
			}
		)
		(
			(
				lv_numRepeats_1_0=RULE_INT
				{
					newLeafNode(lv_numRepeats_1_0, grammarAccess.getNumberRepeatsAccess().getNumRepeatsINTTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getNumberRepeatsRule());
					}
					setWithLastConsumed(
						$current,
						"numRepeats",
						lv_numRepeats_1_0,
						"org.eclipse.xtext.common.Terminals.INT");
				}
			)
		)
	)
;

// Entry rule entryRuleRange
entryRuleRange returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRangeRule()); }
	iv_ruleRange=ruleRange
	{ $current=$iv_ruleRange.current; }
	EOF;

// Rule Range
ruleRange returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getRangeAccess().getRepeatAction_0(),
					$current);
			}
		)
		(
			(
				(
					lv_start_1_0=RULE_INT
					{
						newLeafNode(lv_start_1_0, grammarAccess.getRangeAccess().getStartINTTerminalRuleCall_1_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRangeRule());
						}
						setWithLastConsumed(
							$current,
							"start",
							lv_start_1_0,
							"org.eclipse.xtext.common.Terminals.INT");
					}
				)
			)
			    |
			(
				(
					(
						lv_start_2_0=RULE_INT
						{
							newLeafNode(lv_start_2_0, grammarAccess.getRangeAccess().getStartINTTerminalRuleCall_1_1_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getRangeRule());
							}
							setWithLastConsumed(
								$current,
								"start",
								lv_start_2_0,
								"org.eclipse.xtext.common.Terminals.INT");
						}
					)
				)
				otherlv_3='..'
				{
					newLeafNode(otherlv_3, grammarAccess.getRangeAccess().getFullStopFullStopKeyword_1_1_1());
				}
				(
					(
						lv_end_4_0=RULE_INT
						{
							newLeafNode(lv_end_4_0, grammarAccess.getRangeAccess().getEndINTTerminalRuleCall_1_1_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getRangeRule());
							}
							setWithLastConsumed(
								$current,
								"end",
								lv_end_4_0,
								"org.eclipse.xtext.common.Terminals.INT");
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleResourceYieldMapEntry
entryRuleResourceYieldMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceYieldMapEntryRule()); }
	iv_ruleResourceYieldMapEntry=ruleResourceYieldMapEntry
	{ $current=$iv_ruleResourceYieldMapEntry.current; }
	EOF;

// Rule ResourceYieldMapEntry
ruleResourceYieldMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='yield'
		{
			newLeafNode(otherlv_0, grammarAccess.getResourceYieldMapEntryAccess().getYieldKeyword_0());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceYieldMapEntryRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getResourceYieldMapEntryAccess().getKeyIResourceCrossReference_1_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getResourceYieldMapEntryAccess().getColonKeyword_2());
		}
		(
			(
				lv_value_3_0=RULE_INT
				{
					newLeafNode(lv_value_3_0, grammarAccess.getResourceYieldMapEntryAccess().getValueINTTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceYieldMapEntryRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_3_0,
						"org.eclipse.xtext.common.Terminals.INT");
				}
			)
		)
	)
;

// Entry rule entryRuleAttribute
entryRuleAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAttributeRule()); }
	iv_ruleAttribute=ruleAttribute
	{ $current=$iv_ruleAttribute.current; }
	EOF;

// Rule Attribute
ruleAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAttributeAccess().getAttributeAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getAttributeAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAttributeRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleDispatch
entryRuleDispatch returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDispatchRule()); }
	iv_ruleDispatch=ruleDispatch
	{ $current=$iv_ruleDispatch.current; }
	EOF;

// Rule Dispatch
ruleDispatch returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDispatchRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getDispatchAccess().getActivityActivityCrossReference_0_0());
				}
			)
		)
		(
			otherlv_1='['
			{
				newLeafNode(otherlv_1, grammarAccess.getDispatchAccess().getLeftSquareBracketKeyword_1_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDispatchRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getDispatchAccess().getResourceItemsResourceItemCrossReference_1_1_0());
					}
					ruleResourceItemQualifiedName
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_3=','
				{
					newLeafNode(otherlv_3, grammarAccess.getDispatchAccess().getCommaKeyword_1_2_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getDispatchRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getDispatchAccess().getResourceItemsResourceItemCrossReference_1_2_1_0());
						}
						ruleResourceItemQualifiedName
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_5=']'
			{
				newLeafNode(otherlv_5, grammarAccess.getDispatchAccess().getRightSquareBracketKeyword_1_3());
			}
		)?
		(
			otherlv_6='('
			{
				newLeafNode(otherlv_6, grammarAccess.getDispatchAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					lv_description_7_0=RULE_STRING
					{
						newLeafNode(lv_description_7_0, grammarAccess.getDispatchAccess().getDescriptionSTRINGTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDispatchRule());
						}
						setWithLastConsumed(
							$current,
							"description",
							lv_description_7_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)?
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getDispatchAccess().getUserAttributesAttributesMapEntryParserRuleCall_2_2_0_0());
						}
						lv_userAttributes_8_0=ruleAttributesMapEntry
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getDispatchRule());
							}
							add(
								$current,
								"userAttributes",
								lv_userAttributes_8_0,
								"org.eclipse.lsat.dispatching.teditor.Dispatching.AttributesMapEntry");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_9=','
					{
						newLeafNode(otherlv_9, grammarAccess.getDispatchAccess().getCommaKeyword_2_2_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getDispatchAccess().getUserAttributesAttributesMapEntryParserRuleCall_2_2_1_1_0());
							}
							lv_userAttributes_10_0=ruleAttributesMapEntry
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getDispatchRule());
								}
								add(
									$current,
									"userAttributes",
									lv_userAttributes_10_0,
									"org.eclipse.lsat.dispatching.teditor.Dispatching.AttributesMapEntry");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_11=')'
			{
				newLeafNode(otherlv_11, grammarAccess.getDispatchAccess().getRightParenthesisKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleAttributesMapEntry
entryRuleAttributesMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAttributesMapEntryRule()); }
	iv_ruleAttributesMapEntry=ruleAttributesMapEntry
	{ $current=$iv_ruleAttributesMapEntry.current; }
	EOF;

// Rule AttributesMapEntry
ruleAttributesMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAttributesMapEntryAccess().getAttributesMapEntryAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getAttributesMapEntryAccess().getKeyAttributeParserRuleCall_1_0());
				}
				lv_key_1_0=ruleAttribute
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAttributesMapEntryRule());
					}
					set(
						$current,
						"key",
						lv_key_1_0,
						"org.eclipse.lsat.dispatching.teditor.Dispatching.Attribute");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(':')=>
				otherlv_2=':'
				{
					newLeafNode(otherlv_2, grammarAccess.getAttributesMapEntryAccess().getColonKeyword_2_0());
				}
			)
			    |
			otherlv_3='='
			{
				newLeafNode(otherlv_3, grammarAccess.getAttributesMapEntryAccess().getEqualsSignKeyword_2_1());
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getAttributesMapEntryAccess().getValueIDStringParserRuleCall_3_0_0());
					}
					lv_value_4_1=ruleIDString
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAttributesMapEntryRule());
						}
						set(
							$current,
							"value",
							lv_value_4_1,
							"org.eclipse.lsat.dispatching.teditor.Dispatching.IDString");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getAttributesMapEntryAccess().getValueINTASStringParserRuleCall_3_0_1());
					}
					lv_value_4_2=ruleINTASString
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAttributesMapEntryRule());
						}
						set(
							$current,
							"value",
							lv_value_4_2,
							"org.eclipse.lsat.dispatching.teditor.Dispatching.INTASString");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getImportAccess().getImportAction_0(),
					$current);
			}
		)
		otherlv_1='import'
		{
			newLeafNode(otherlv_1, grammarAccess.getImportAccess().getImportKeyword_1());
		}
		(
			(
				lv_importURI_2_0=RULE_STRING
				{
					newLeafNode(lv_importURI_2_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_2_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleEBigDecimal
entryRuleEBigDecimal returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEBigDecimalRule()); }
	iv_ruleEBigDecimal=ruleEBigDecimal
	{ $current=$iv_ruleEBigDecimal.current.getText(); }
	EOF;

// Rule EBigDecimal
ruleEBigDecimal returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			kw='-'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_0());
			}
		)?
		this_INT_1=RULE_INT
		{
			$current.merge(this_INT_1);
		}
		{
			newLeafNode(this_INT_1, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_1());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getFullStopKeyword_2_0());
			}
			this_INT_3=RULE_INT
			{
				$current.merge(this_INT_3);
			}
			{
				newLeafNode(this_INT_3, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_2_1());
			}
		)?
		(
			(
				kw='E'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_0());
				}
				    |
				kw='e'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_1());
				}
			)
			(
				kw='-'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_3_1());
				}
			)?
			this_INT_7=RULE_INT
			{
				$current.merge(this_INT_7);
			}
			{
				newLeafNode(this_INT_7, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_3_2());
			}
		)?
	)
;

// Entry rule entryRuleIDString
entryRuleIDString returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIDStringRule()); }
	iv_ruleIDString=ruleIDString
	{ $current=$iv_ruleIDString.current.getText(); }
	EOF;

// Rule IDString
ruleIDString returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getIDStringAccess().getIDTerminalRuleCall_0());
		}
		    |
		this_STRING_1=RULE_STRING
		{
			$current.merge(this_STRING_1);
		}
		{
			newLeafNode(this_STRING_1, grammarAccess.getIDStringAccess().getSTRINGTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleINTASString
entryRuleINTASString returns [String current=null]:
	{ newCompositeNode(grammarAccess.getINTASStringRule()); }
	iv_ruleINTASString=ruleINTASString
	{ $current=$iv_ruleINTASString.current.getText(); }
	EOF;

// Rule INTASString
ruleINTASString returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	this_INT_0=RULE_INT
	{
		$current.merge(this_INT_0);
	}
	{
		newLeafNode(this_INT_0, grammarAccess.getINTASStringAccess().getINTTerminalRuleCall());
	}
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleResourceQualifiedName
entryRuleResourceQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getResourceQualifiedNameRule()); }
	iv_ruleResourceQualifiedName=ruleResourceQualifiedName
	{ $current=$iv_ruleResourceQualifiedName.current.getText(); }
	EOF;

// Rule ResourceQualifiedName
ruleResourceQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_0());
		}
		this_IID_0=ruleIID
		{
			$current.merge(this_IID_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getResourceQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_1_1());
			}
			this_IID_2=ruleIID
			{
				$current.merge(this_IID_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)?
	)
;

// Entry rule entryRuleResourceItemQualifiedName
entryRuleResourceItemQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getResourceItemQualifiedNameRule()); }
	iv_ruleResourceItemQualifiedName=ruleResourceItemQualifiedName
	{ $current=$iv_ruleResourceItemQualifiedName.current.getText(); }
	EOF;

// Rule ResourceItemQualifiedName
ruleResourceItemQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getResourceItemQualifiedNameAccess().getIIDParserRuleCall_0());
		}
		this_IID_0=ruleIID
		{
			$current.merge(this_IID_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getResourceItemQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getResourceItemQualifiedNameAccess().getIIDParserRuleCall_1_1());
			}
			this_IID_2=ruleIID
			{
				$current.merge(this_IID_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)?
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
