/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Sprand;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class SprandFullBenchmark
extends Benchmark {
    private final String name;
    private final Integer numberOfVerticesMin;
    private final Integer numberOfVerticesMax;
    private final Integer stepSize;
    private final Integer edgeRatio;
    private final Integer maxWeight1;
    private final Integer maxWeight2;
    private PrintWriter file;

    public SprandFullBenchmark(String name, Integer numberOfVerticesMin, Integer numberOfVerticesMax, Integer stepSize, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2) {
        this.name = name;
        this.numberOfVerticesMin = numberOfVerticesMin;
        this.numberOfVerticesMax = numberOfVerticesMax;
        this.stepSize = stepSize;
        this.edgeRatio = edgeRatio;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIterationN", "EnergyGameN", "ZwickPatersonN", "PolicyIterationRE105", "EnergyGameRE105", "ZwickPatersonRE105", "PolicyIterationRInt", "EnergyGameRInt", "ZwickPatersonRInt");
        System.out.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIterationN", "EnergyGameN", "ZwickPatersonN", "PolicyIterationRE105", "EnergyGameRE105", "ZwickPatersonRE105", "PolicyIterationRInt", "EnergyGameRInt", "ZwickPatersonRInt");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.numberOfVerticesMin;
            while (v <= this.numberOfVerticesMax) {
                this.runAlgorithmsSprand(v, this.edgeRatio, this.maxWeight1, this.maxWeight2, runPI, runEG, runZP);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsSprand(Integer numberOfVertices, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2, boolean runPI, boolean runEG, boolean runZP) {
        RGIntImplJGraphT sprandGraph = Sprand.generateRatioGame(numberOfVertices, edgeRatio, maxWeight1, maxWeight2);
        float piSec = 0.0f;
        if (runPI) {
            long piResult = this.runPI(sprandGraph);
            piSec = (float)piResult / 1.0E9f;
        }
        float egSec = 0.0f;
        if (runEG) {
            long egResult = this.runEG(sprandGraph);
            egSec = (float)egResult / 1.0E9f;
        }
        float zpSec = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(sprandGraph);
            zpSec = (float)zpResult / 1.0E9f;
        }
        RGDoubleImplJGraphT sprandDoubleGraph = this.toDoubleGameGraph(sprandGraph);
        Double epsilon = 1.0E-4;
        float piSecD = 0.0f;
        if (runPI) {
            long piResult = this.runPI(sprandDoubleGraph, epsilon);
            piSecD = (float)piResult / 1.0E9f;
        }
        float egSecD = 0.0f;
        if (runEG) {
            long egResult = this.runEG(sprandDoubleGraph, epsilon);
            egSecD = (float)egResult / 1.0E9f;
        }
        float zpSecD = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(sprandDoubleGraph, epsilon);
            zpSecD = (float)zpResult / 1.0E9f;
        }
        long vertexNum = numberOfVertices.intValue();
        long numberOfEdges = vertexNum * vertexNum;
        epsilon = 1.0 / (double)numberOfEdges;
        epsilon = Double.max(1.0E-13, epsilon);
        float piSecD2 = 0.0f;
        if (runPI) {
            long piResult = this.runPI(sprandDoubleGraph, epsilon);
            piSecD2 = (float)piResult / 1.0E9f;
        }
        float egSecD2 = 0.0f;
        if (runEG) {
            long egResult = this.runEG(sprandDoubleGraph, epsilon);
            egSecD2 = (float)egResult / 1.0E9f;
        }
        float zpSecD2 = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(sprandDoubleGraph, epsilon);
            zpSecD2 = (float)zpResult / 1.0E9f;
        }
        this.file.printf("%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec), Float.valueOf(piSecD), Float.valueOf(egSecD), Float.valueOf(zpSecD), Float.valueOf(piSecD2), Float.valueOf(egSecD2), Float.valueOf(zpSecD2));
        System.out.printf("%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec), Float.valueOf(piSecD), Float.valueOf(egSecD), Float.valueOf(zpSecD), Float.valueOf(piSecD2), Float.valueOf(egSecD2), Float.valueOf(zpSecD2));
    }

    private RGDoubleImplJGraphT toDoubleGameGraph(RGIntImplJGraphT ratioGame) {
        DoubleWeightFunctionInt<JGraphTEdge> f = ratioGame.getEdgeWeights();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTEdge e : ratioGame.getEdges()) {
            weights.addWeight(e, (double)((Integer)f.getWeight1((Object)e)).intValue() * 1.0, (double)((Integer)f.getWeight2((Object)e)).intValue() * 1.0);
        }
        return new RGDoubleImplJGraphT(ratioGame.getGraph(), weights);
    }
}

