/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator;

import java.util.Random;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class Tor {
    private Tor() {
    }

    public static RGDoubleImplJGraphT generateRatioGame(Integer size, Double maxWeight1, Double maxWeight2) {
        int j;
        Random rand = new Random();
        Integer max1 = (int)Math.round(maxWeight1);
        Integer max2 = (int)Math.round(maxWeight2);
        JGraphTGraph graph = new JGraphTGraph();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        JGraphTVertex[][] grid = new JGraphTVertex[size.intValue()][size.intValue()];
        int i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTVertex v = new JGraphTVertex(i * size + j);
                boolean addToV0 = rand.nextBoolean();
                if (addToV0) {
                    graph.addToV0(v);
                } else {
                    graph.addToV1(v);
                }
                grid[i][j] = v;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTEdge rightEdge = graph.addEdge(grid[i][j], grid[i][(j + 1) % size]);
                Double weight1 = 1.0 + ((double)max1.intValue() - 1.0) * rand.nextDouble();
                Double weight2 = 1.0 + ((double)max2.intValue() - 1.0) * rand.nextDouble();
                weights.addWeight(rightEdge, weight1, weight2);
                JGraphTEdge upEdge = graph.addEdge(grid[i][j], grid[Tor.mod(i - 1, size)][j]);
                weight1 = 1.0 + ((double)max1.intValue() - 1.0) * rand.nextDouble();
                weight2 = 1.0 + ((double)max2.intValue() - 1.0) * rand.nextDouble();
                weights.addWeight(upEdge, weight1, weight2);
                ++j;
            }
            ++i;
        }
        return new RGDoubleImplJGraphT(graph, weights);
    }

    public static RGIntImplJGraphT generateRatioGame(Integer size, Integer maxWeight1, Integer maxWeight2) {
        int j;
        Random rand = new Random();
        JGraphTGraph graph = new JGraphTGraph();
        DoubleWeightFunctionInt<JGraphTEdge> weights = new DoubleWeightFunctionInt<JGraphTEdge>();
        JGraphTVertex[][] grid = new JGraphTVertex[size.intValue()][size.intValue()];
        int i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTVertex v = new JGraphTVertex(i * size + j);
                boolean addToV0 = rand.nextBoolean();
                if (addToV0) {
                    graph.addToV0(v);
                } else {
                    graph.addToV1(v);
                }
                grid[i][j] = v;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTEdge rightEdge = graph.addEdge(grid[i][j], grid[i][(j + 1) % size]);
                Integer w1 = rand.nextInt(maxWeight1 - 1) + 1;
                Integer w2 = rand.nextInt(maxWeight2 - 1) + 1;
                weights.addWeight(rightEdge, w1, w2);
                JGraphTEdge upEdge = graph.addEdge(grid[i][j], grid[Tor.mod(i - 1, size)][j]);
                w1 = rand.nextInt(maxWeight1 - 1) + 1;
                w2 = rand.nextInt(maxWeight2 - 1) + 1;
                weights.addWeight(upEdge, w1, w2);
                ++j;
            }
            ++i;
        }
        return new RGIntImplJGraphT(graph, weights);
    }

    public static RGDoubleImplJGraphT generateRatioGameDouble(Integer size, Integer maxWeight1, Integer maxWeight2) {
        int j;
        Random rand = new Random();
        JGraphTGraph graph = new JGraphTGraph();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        JGraphTVertex[][] grid = new JGraphTVertex[size.intValue()][size.intValue()];
        int i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTVertex v = new JGraphTVertex(i * size + j);
                boolean addToV0 = rand.nextBoolean();
                if (addToV0) {
                    graph.addToV0(v);
                } else {
                    graph.addToV1(v);
                }
                grid[i][j] = v;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j < size) {
                JGraphTEdge rightEdge = graph.addEdge(grid[i][j], grid[i][(j + 1) % size]);
                Integer w1 = rand.nextInt(maxWeight1 - 1) + 1;
                Integer w2 = rand.nextInt(maxWeight2 - 1) + 1;
                weights.addWeight(rightEdge, (double)w1.intValue() * 1.0, (double)w2.intValue() * 1.0);
                JGraphTEdge upEdge = graph.addEdge(grid[i][j], grid[Tor.mod(i - 1, size)][j]);
                w1 = rand.nextInt(maxWeight1 - 1) + 1;
                w2 = rand.nextInt(maxWeight2 - 1) + 1;
                weights.addWeight(upEdge, (double)w1.intValue() * 1.0, (double)w2.intValue() * 1.0);
                ++j;
            }
            ++i;
        }
        return new RGDoubleImplJGraphT(graph, weights);
    }

    private static int mod(int x, int n) {
        int r = x % n;
        if (r < 0) {
            r += n;
        }
        return r;
    }
}

