/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.energy.solvers;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.games.energy.EnergyGame;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.SEPM;

public class ValueIterationDouble {
    public static final Double TOP = Double.MAX_VALUE;

    private ValueIterationDouble() {
    }

    private static <V, E> Predicate<V> allSuccessorsNegative(EnergyGame<V, E, Double> game) {
        return v -> game.outgoingEdgesOf(v).stream().allMatch(e -> (Double)game.getWeight(e) < 0.0);
    }

    private static <V, E> Predicate<V> anySuccessorNegative(EnergyGame<V, E, Double> game) {
        return v -> game.outgoingEdgesOf(v).stream().anyMatch(e -> (Double)game.getWeight(e) < 0.0);
    }

    private static <V, E> Predicate<E> isConsistentSuccessor(EnergyGame<V, E, Double> game, SEPM<V, Double> sepm) {
        return e -> (Double)sepm.getValue(game.getEdgeSource(e)) >= ValueIterationDouble.minus((Double)game.getSumNegWeights(), (Double)sepm.getValue(game.getEdgeTarget(e)), (Double)game.getWeight(game.getEdge(game.getEdgeSource(e), game.getEdgeTarget(e))));
    }

    private static double minus(double sumNegativeWeights, double a, double b) {
        if (a < TOP && a - b <= sumNegativeWeights) {
            return Math.max(0.0, a - b);
        }
        return TOP;
    }

    private static <V, E> double lift(EnergyGame<V, E, Double> game, SEPM<V, Double> sepm, V vertex) {
        double newValue = game.getV0().contains(vertex) ? game.outgoingEdgesOf(vertex).stream().mapToDouble(e -> ValueIterationDouble.minus((Double)game.getSumNegWeights(), (Double)sepm.getValue(game.getEdgeTarget(e)), (Double)game.getWeight(e))).reduce(Double.POSITIVE_INFINITY, Double::min) : game.outgoingEdgesOf(vertex).stream().mapToDouble(e -> ValueIterationDouble.minus((Double)game.getSumNegWeights(), (Double)sepm.getValue(game.getEdgeTarget(e)), (Double)game.getWeight(e))).reduce(Double.NEGATIVE_INFINITY, Double::max);
        return newValue;
    }

    public static <V, E> SEPM<V, Double> getProgressMeasure(EnergyGame<V, E, Double> game) {
        assert (game != null);
        HashMap count = new HashMap();
        ArrayDeque l = new ArrayDeque();
        SEPM sepm = new SEPM();
        l.addAll(game.getV0().stream().filter(ValueIterationDouble.allSuccessorsNegative(game)).collect(Collectors.toSet()));
        l.addAll(game.getV1().stream().filter(ValueIterationDouble.anySuccessorNegative(game)).collect(Collectors.toSet()));
        game.getVertices().forEach(v -> sepm.setValue(v, 0.0));
        game.getV0().forEach(v -> {
            if (l.contains(v)) {
                count.put(v, 0);
            } else {
                int numberOfConsistentVertices = (int)game.outgoingEdgesOf(v).stream().filter(ValueIterationDouble.isConsistentSuccessor(game, sepm)).count();
                count.put(v, numberOfConsistentVertices);
            }
        });
        while (!l.isEmpty()) {
            Object v2 = l.pop();
            double old = (Double)sepm.getValue(v2);
            sepm.setValue(v2, ValueIterationDouble.lift(game, sepm, v2));
            if (game.getV0().contains(v2)) {
                int numberOfConsistentVertices = (int)game.outgoingEdgesOf(v2).stream().filter(ValueIterationDouble.isConsistentSuccessor(game, sepm)).count();
                count.put(v2, numberOfConsistentVertices);
            }
            game.incomingEdgesOf(v2).forEach(e -> {
                Object vPre = game.getEdgeSource(e);
                if ((Double)sepm.getValue(vPre) < ValueIterationDouble.minus((Double)game.getSumNegWeights(), (Double)sepm.getValue(v2), (Double)game.getWeight(e))) {
                    if (game.getV0().contains(vPre)) {
                        if ((Double)sepm.getValue(vPre) >= ValueIterationDouble.minus((Double)game.getSumNegWeights(), old, (Double)game.getWeight(e))) {
                            count.put(vPre, (Integer)count.get(vPre) - 1);
                        }
                        if ((Integer)count.get(vPre) <= 0 && !l.contains(vPre)) {
                            l.add(vPre);
                        }
                    } else if (!l.contains(vPre)) {
                        l.add(vPre);
                    }
                }
            });
        }
        return sepm;
    }

    public static <V, E> Optional<E> getConsistentSuccessor(EnergyGame<V, E, Double> game, SEPM<V, Double> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationDouble.isConsistentSuccessor(game, sepm)).findFirst();
    }

    public static <V, E> Optional<E> getLargestConsistentSuccessor(EnergyGame<V, E, Double> game, SEPM<V, Double> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationDouble.isConsistentSuccessor(game, sepm)).max(Comparator.comparing(e -> (Double)sepm.getValue(game.getEdgeTarget(e))));
    }

    public static <V, E> Optional<E> getSmallestConsistentSuccessor(EnergyGame<V, E, Double> game, SEPM<V, Double> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationDouble.isConsistentSuccessor(game, sepm)).min(Comparator.comparing(e -> (Double)sepm.getValue(game.getEdgeTarget(e))));
    }
}

