/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.por;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.por.DependencyInterface;

public class DependencyGraph
implements DependencyInterface {
    private final Map<String, Set<String>> edges = new HashMap<String, Set<String>>();
    private final Set<String> nodes = new HashSet<String>();

    public Set<String> getNodes() {
        return this.nodes;
    }

    @Override
    public Set<String> getDependencies(String node) {
        return this.edges.getOrDefault(node, new HashSet());
    }

    @Override
    public boolean hasDependency(String node1, String node2) {
        Set node1deps = this.edges.getOrDefault(node1, new HashSet());
        return node1deps.contains(node2);
    }

    public void addNode(String node) {
        this.nodes.add(node);
    }

    public void addDependency(String node1, String node2) {
        this.addDirectedDependency(node1, node2);
        this.addDirectedDependency(node2, node1);
        this.nodes.add(node1);
        this.nodes.add(node2);
    }

    private void addDirectedDependency(String node1, String node2) {
        this.edges.putIfAbsent(node1, new HashSet());
        Set<String> node1Dependencies = this.edges.get(node1);
        node1Dependencies.add(node2);
    }
}

