/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.automaton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.automaton.MPAState;
import org.eclipse.lsat.common.ludus.backend.automaton.MPATransition;
import org.eclipse.lsat.common.ludus.backend.automaton.MaxPlusAutomaton;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.RatioGamePolicyIteration;

public class MPGA<T>
extends MaxPlusAutomaton<T>
implements RatioGamePolicyIteration<MPAState<T>, MPATransition<T>, Value> {
    private static final long serialVersionUID = 1L;
    private final Set<MPAState<T>> player0states = new HashSet<MPAState<T>>();
    private final Set<MPAState<T>> player1states = new HashSet<MPAState<T>>();
    private final Map<MPAState<T>, Integer> idMap = new HashMap<MPAState<T>, Integer>();
    private Integer currentId = 0;

    @Override
    public void addState(MPAState<T> MPAState2) {
        super.addState(MPAState2);
        if (MPAState2.getIndex() < 0) {
            this.player1states.add(MPAState2);
        } else {
            this.player0states.add(MPAState2);
        }
        this.idMap.put(MPAState2, this.currentId);
        this.currentId = this.currentId + 1;
    }

    @Override
    public Set<MPAState<T>> getV0() {
        return this.player0states;
    }

    @Override
    public Set<MPAState<T>> getV1() {
        return this.player1states;
    }

    @Override
    public Value getMaxAbsValue() {
        Value max = Value.NEGATIVE_INFINITY;
        for (MPATransition t : this.getEdges()) {
            max = max.max(this.getWeight1(t));
            max = max.max(this.getWeight2(t));
        }
        return max;
    }

    @Override
    public Integer getId(MPAState<T> vertex) {
        return this.idMap.get(vertex);
    }
}

