/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator.json.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.lsat.motioncalculator.json.JsonRequest;
import org.eclipse.lsat.motioncalculator.json.JsonRequestType;
import org.eclipse.lsat.motioncalculator.json.JsonResponse;
import org.eclipse.lsat.motioncalculator.json.JsonSerializer;
import org.eclipse.lsat.motioncalculator.json.JsonServer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.prefs.Preferences;

public class NativeJsonServer
implements JsonServer {
    private static final String ARROW_LEFT = "\u2190 ";
    private static final String ARROW_RIGHT = "\u2192 ";
    public static final Color REQUEST_COLOR = new Color(null, 29, 53, 87);
    public static final Color RESPONSE_COLOR = new Color(null, 69, 123, 157);
    private static final int MAX_BUFFER_SIZE = 100000;
    private static final int SMALL_BUFFER_SIZE = 10000;
    private static final Preferences PREFERENCES = InstanceScope.INSTANCE.getNode("org.eclipse.lsat.motioncalculator.json.jna");
    private static String sharedLibName = null;
    private static JsonServerJNA instance;
    private static Throwable error;
    private static MessageConsole console;
    private final JsonServerJNA server = NativeJsonServer.getServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonServerJNA getServer() {
        Preferences preferences = PREFERENCES;
        synchronized (preferences) {
            boolean writeMessages = PREFERENCES.getBoolean("WRITE_MESSAGES", false);
            if (writeMessages && console == null) {
                console = new MessageConsole("Motion calculator", null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
            } else if (!writeMessages) {
                if (console != null) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
                }
                console = null;
            }
            String libName = PREFERENCES.get("LIBRARY", sharedLibName);
            if (instance == null || libName != sharedLibName) {
                sharedLibName = libName;
                try {
                    instance = sharedLibName != null ? (JsonServerJNA)Native.loadLibrary((String)sharedLibName, JsonServerJNA.class, new HashMap()) : null;
                    error = null;
                }
                catch (Throwable e) {
                    error = e;
                }
            }
        }
        return instance;
    }

    public final String request(String request) {
        if (this.server != null) {
            try {
                this.logRequest(request);
                byte[] responseBytes = new byte[10000];
                byte[] utf8Request = request.getBytes(StandardCharsets.UTF_8);
                byte[] requestBytes = new byte[utf8Request.length + 1];
                System.arraycopy(utf8Request, 0, requestBytes, 0, utf8Request.length);
                int errorCode = this.server.request(responseBytes, requestBytes, 10000);
                if (errorCode != 0) {
                    responseBytes = new byte[100000];
                    Arrays.fill(responseBytes, (byte)-1);
                    errorCode = this.server.request(responseBytes, requestBytes, 100000);
                    if (errorCode != 0) {
                        return NativeJsonServer.error(request, "Buffer overflow detected error code (" + errorCode + ")", null);
                    }
                }
                String response = Native.toString((byte[])responseBytes, (String)"UTF-8");
                this.logResponse(response);
                return response;
            }
            catch (Throwable e) {
                return NativeJsonServer.error(request, "Invokation Error", e);
            }
        }
        JsonRequest jsonRequest = JsonSerializer.createRequest((String)request);
        if (jsonRequest.getRequestType() == JsonRequestType.SupportedProfiles) {
            JsonResponse jsonResponse = new JsonResponse();
            jsonResponse.setRequestType(jsonRequest.getRequestType());
            return JsonSerializer.toJson((JsonResponse)jsonResponse);
        }
        return NativeJsonServer.error(request, "Unable to instantiate shared library", error);
    }

    private void logRequest(String request) {
        NativeJsonServer.log(console, REQUEST_COLOR, ARROW_RIGHT, request);
    }

    private void logResponse(String response) {
        if (console != null) {
            try {
                JsonResponse r = JsonSerializer.createResponse((String)response);
                response = JsonSerializer.toJson((JsonResponse)r);
                if (response == null || response.isEmpty()) {
                    response = "{}";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            NativeJsonServer.log(console, RESPONSE_COLOR, ARROW_LEFT, response);
        }
    }

    private static void log(MessageConsole console, Color color, String ... strs) {
        if (console != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (MessageConsoleStream stream = console.newMessageStream();){
                    stream.setCharset(StandardCharsets.UTF_8);
                    stream.setColor(color);
                    stream.setActivateOnWrite(false);
                    String[] stringArray = strs;
                    int n = strs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        stream.print(str);
                        ++n2;
                    }
                    stream.println();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String error(String request, String message, Throwable error) {
        JsonRequest jsonRequest = JsonSerializer.createRequest((String)request);
        JsonResponse jsonResponse = new JsonResponse();
        jsonResponse.setRequestType(jsonRequest.getRequestType());
        jsonResponse.setErrorMessage(message + " " + sharedLibName + (String)(error != null ? " error: " + error.getMessage() : ""));
        String response = JsonSerializer.toJson((JsonResponse)jsonResponse);
        return response;
    }

    public static interface JsonServerJNA
    extends Library {
        public int request(byte[] var1, byte[] var2, int var3);
    }
}

