/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import machine.Axis;
import machine.Distance;
import machine.Peripheral;
import machine.PeripheralType;

public final class AxesDistance
extends HashMap<Axis, BigDecimal> {
    private static final long serialVersionUID = 6227801704225324973L;
    private final Distance distance;

    AxesDistance(Distance distance) {
        super(AxesDistance.safeGetAxes(distance).size());
        this.distance = distance;
    }

    public Distance getDistance() {
        return this.distance;
    }

    public PeripheralType getPeripheralType() {
        return this.distance.getPeripheral().getType();
    }

    public Set<Axis> getMovingAxes() {
        LinkedHashSet<Axis> movingAxes = new LinkedHashSet<Axis>(this.getPeripheralType().getAxes().size());
        for (Map.Entry entry : this.entrySet()) {
            if (BigDecimal.ZERO.equals(entry.getValue())) continue;
            movingAxes.add((Axis)entry.getKey());
        }
        return movingAxes;
    }

    static final List<Axis> safeGetAxes(Distance distance) {
        if (distance == null) {
            return Collections.emptyList();
        }
        Peripheral peripheral = distance.getPeripheral();
        if (peripheral == null) {
            return Collections.emptyList();
        }
        PeripheralType peripheralType = peripheral.getType();
        if (peripheralType == null) {
            return Collections.emptyList();
        }
        return peripheralType.getAxes();
    }
}

