/**
 */
package activity.impl;

import activity.Activity;
import activity.ActivityPackage;
import activity.ConstraintEdge;
import activity.LocationPrerequisite;

import common.CommonPackage;
import common.HasParameterDeclarations;
import common.ParameterDeclaration;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import machine.Resource;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.lsat.common.graph.directed.editable.impl.EditableDirectedGraphImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Activity</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link activity.impl.ActivityImpl#getParameterDeclarations <em>Parameter Declarations</em>}</li>
 *   <li>{@link activity.impl.ActivityImpl#getPrerequisites <em>Prerequisites</em>}</li>
 *   <li>{@link activity.impl.ActivityImpl#getOriginalName <em>Original Name</em>}</li>
 *   <li>{@link activity.impl.ActivityImpl#getConstraints <em>Constraints</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ActivityImpl extends EditableDirectedGraphImpl implements Activity
{
    /**
     * The cached value of the '{@link #getParameterDeclarations() <em>Parameter Declarations</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getParameterDeclarations()
     * @generated
     * @ordered
     */
    protected EList<ParameterDeclaration> parameterDeclarations;

    /**
     * The cached value of the '{@link #getPrerequisites() <em>Prerequisites</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPrerequisites()
     * @generated
     * @ordered
     */
    protected EList<LocationPrerequisite> prerequisites;

    /**
     * The default value of the '{@link #getOriginalName() <em>Original Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOriginalName()
     * @generated
     * @ordered
     */
    protected static final String ORIGINAL_NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getOriginalName() <em>Original Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getOriginalName()
     * @generated
     * @ordered
     */
    protected String originalName = ORIGINAL_NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getConstraints() <em>Constraints</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getConstraints()
     * @generated
     * @ordered
     */
    protected EList<ConstraintEdge> constraints;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ActivityImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return ActivityPackage.Literals.ACTIVITY;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<ParameterDeclaration> getParameterDeclarations()
    {
        if (parameterDeclarations == null)
        {
            parameterDeclarations = new EObjectContainmentEList<ParameterDeclaration>(ParameterDeclaration.class, this, ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS);
        }
        return parameterDeclarations;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<LocationPrerequisite> getPrerequisites()
    {
        if (prerequisites == null)
        {
            prerequisites = new EObjectContainmentWithInverseEList<LocationPrerequisite>(LocationPrerequisite.class, this, ActivityPackage.ACTIVITY__PREREQUISITES, ActivityPackage.LOCATION_PREREQUISITE__ACTIVITY);
        }
        return prerequisites;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String getOriginalName()
    {
        return originalName;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setOriginalName(String newOriginalName)
    {
        String oldOriginalName = originalName;
        originalName = newOriginalName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ActivityPackage.ACTIVITY__ORIGINAL_NAME, oldOriginalName, originalName));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<ConstraintEdge> getConstraints()
    {
        if (constraints == null)
        {
            constraints = new EObjectContainmentEList<ConstraintEdge>(ConstraintEdge.class, this, ActivityPackage.ACTIVITY__CONSTRAINTS);
        }
        return constraints;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isExpanded()
    {
        if (getOriginalName()==null) return false; 
        return  !java.util.Objects.equals(getName(),getOriginalName());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public EList<Resource> getResourcesNeedingItem()
    {
        return new org.eclipse.emf.common.util.BasicEList<Resource>(
            getNodes().stream().filter(activity.ResourceAction.class::isInstance).map(activity.ResourceAction.class::cast)
            .map(activity.ResourceAction::getResource).filter(machine.Resource.class::isInstance)
            .map(machine.Resource.class::cast).filter(r -> !r.getItems().isEmpty())
            .distinct()
            .sorted( (r1,r2) ->  r1.getName().compareTo(r2.getName()))
            .collect(java.util.stream.Collectors.toCollection(java.util.LinkedHashSet::new)));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getPrerequisites()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS:
                return ((InternalEList<?>)getParameterDeclarations()).basicRemove(otherEnd, msgs);
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                return ((InternalEList<?>)getPrerequisites()).basicRemove(otherEnd, msgs);
            case ActivityPackage.ACTIVITY__CONSTRAINTS:
                return ((InternalEList<?>)getConstraints()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS:
                return getParameterDeclarations();
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                return getPrerequisites();
            case ActivityPackage.ACTIVITY__ORIGINAL_NAME:
                return getOriginalName();
            case ActivityPackage.ACTIVITY__CONSTRAINTS:
                return getConstraints();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS:
                getParameterDeclarations().clear();
                getParameterDeclarations().addAll((Collection<? extends ParameterDeclaration>)newValue);
                return;
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                getPrerequisites().clear();
                getPrerequisites().addAll((Collection<? extends LocationPrerequisite>)newValue);
                return;
            case ActivityPackage.ACTIVITY__ORIGINAL_NAME:
                setOriginalName((String)newValue);
                return;
            case ActivityPackage.ACTIVITY__CONSTRAINTS:
                getConstraints().clear();
                getConstraints().addAll((Collection<? extends ConstraintEdge>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS:
                getParameterDeclarations().clear();
                return;
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                getPrerequisites().clear();
                return;
            case ActivityPackage.ACTIVITY__ORIGINAL_NAME:
                setOriginalName(ORIGINAL_NAME_EDEFAULT);
                return;
            case ActivityPackage.ACTIVITY__CONSTRAINTS:
                getConstraints().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS:
                return parameterDeclarations != null && !parameterDeclarations.isEmpty();
            case ActivityPackage.ACTIVITY__PREREQUISITES:
                return prerequisites != null && !prerequisites.isEmpty();
            case ActivityPackage.ACTIVITY__ORIGINAL_NAME:
                return ORIGINAL_NAME_EDEFAULT == null ? originalName != null : !ORIGINAL_NAME_EDEFAULT.equals(originalName);
            case ActivityPackage.ACTIVITY__CONSTRAINTS:
                return constraints != null && !constraints.isEmpty();
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass)
    {
        if (baseClass == HasParameterDeclarations.class)
        {
            switch (derivedFeatureID)
            {
                case ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS: return CommonPackage.HAS_PARAMETER_DECLARATIONS__PARAMETER_DECLARATIONS;
                default: return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass)
    {
        if (baseClass == HasParameterDeclarations.class)
        {
            switch (baseFeatureID)
            {
                case CommonPackage.HAS_PARAMETER_DECLARATIONS__PARAMETER_DECLARATIONS: return ActivityPackage.ACTIVITY__PARAMETER_DECLARATIONS;
                default: return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case ActivityPackage.ACTIVITY___IS_EXPANDED:
                return isExpanded();
            case ActivityPackage.ACTIVITY___GET_RESOURCES_NEEDING_ITEM:
                return getResourcesNeedingItem();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (originalName: ");
        result.append(originalName);
        result.append(')');
        return result.toString();
    }

} //ActivityImpl
