/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.progress.LSPProgressManager;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;

public class LanguageClientImpl
implements LanguageClient {
    private Consumer<PublishDiagnosticsParams> diagnosticConsumer = (Consumer)NullSafetyHelper.lateNonNull();
    private final LSPProgressManager progressManager = new LSPProgressManager();
    private LanguageServer server = (LanguageServer)NullSafetyHelper.lateNonNull();
    private LanguageServerWrapper wrapper = (LanguageServerWrapper)NullSafetyHelper.lateNonNull();

    public final void connect(LanguageServer server, LanguageServerWrapper wrapper) {
        this.server = server;
        this.wrapper = wrapper;
        this.progressManager.connect(server, wrapper.serverDefinition);
    }

    protected void setDiagnosticsConsumer(Consumer<PublishDiagnosticsParams> diagnosticConsumer) {
        this.diagnosticConsumer = diagnosticConsumer;
    }

    protected final LanguageServer getLanguageServer() {
        return this.server;
    }

    public CompletableFuture<List<@Nullable Object>> configuration(ConfigurationParams configurationParams) {
        ArrayList<Object> list = new ArrayList<Object>(configurationParams.getItems().size());
        int i = 0;
        while (i < configurationParams.getItems().size()) {
            list.add(null);
            ++i;
        }
        return CompletableFuture.completedFuture(list);
    }

    public void telemetryEvent(@Nullable Object object) {
    }

    public final CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return ServerMessageHandler.showMessageRequest(this.wrapper, requestParams);
    }

    public final void showMessage(MessageParams messageParams) {
        ServerMessageHandler.showMessage(this.wrapper.serverDefinition.label, messageParams);
    }

    public final void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.diagnosticConsumer.accept(diagnostics);
    }

    public final void logMessage(MessageParams message) {
        CompletableFuture.runAsync(() -> ServerMessageHandler.logMessage(this.wrapper, message));
    }

    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return this.progressManager.createProgress(params);
    }

    public void notifyProgress(ProgressParams params) {
        this.progressManager.notifyProgress(params);
    }

    public final CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(final ApplyWorkspaceEditParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Job job = new Job(Messages.serverEdit){

                public IStatus run(IProgressMonitor monitor) {
                    LSPEclipseUtils.applyWorkspaceEdit(params.getEdit(), params.getLabel());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
                return new ApplyWorkspaceEditResponse(true);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return new ApplyWorkspaceEditResponse(false);
            }
        });
    }

    public CompletableFuture<@Nullable Void> registerCapability(RegistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.registerCapability(params));
    }

    public CompletableFuture<@Nullable Void> unregisterCapability(UnregistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.unregisterCapability(params));
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        return CompletableFuture.completedFuture(LSPEclipseUtils.getWorkspaceFolders());
    }

    public CompletableFuture<ShowDocumentResult> showDocument(ShowDocumentParams params) {
        return CompletableFuture.supplyAsync(() -> {
            UI.getDisplay().syncExec(() -> {
                Location location = new Location(params.getUri(), params.getSelection());
                LSPEclipseUtils.openInEditor(location);
            });
            return new ShowDocumentResult(true);
        });
    }

    private void updateCodeMinings() {
        IEditorReference[] editors;
        IWorkbenchPage activePage = UI.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = activePage.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            ITextViewer textViewer = (ITextViewer)Adapters.adapt((Object)editor, ITextViewer.class, (boolean)true);
            if (textViewer != null && textViewer instanceof SourceViewer) {
                SourceViewer sourceViewer = (SourceViewer)textViewer;
                sourceViewer.updateCodeMinings();
            }
            ++n2;
        }
    }

    public CompletableFuture<@Nullable Void> refreshCodeLenses() {
        return CompletableFuture.runAsync(() -> UI.getDisplay().syncExec(this::updateCodeMinings));
    }

    public CompletableFuture<@Nullable Void> refreshInlayHints() {
        return CompletableFuture.runAsync(() -> UI.getDisplay().syncExec(this::updateCodeMinings));
    }

    public void dispose() {
        this.progressManager.dispose();
    }
}

