/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

final class DeferredOpenMultiDeclarationHyperlink
implements IHyperlink {
    private static final long DEFERRED_OPEN_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private final ITextViewer viewer;
    private final IDocument document;
    private final long documentInitialModificationStamp;
    private final IRegion region;
    private final CompletableFuture<? extends List<? extends IHyperlink>> future;
    private final long createdNanos = System.nanoTime();

    DeferredOpenMultiDeclarationHyperlink(ITextViewer viewer, IDocument document, IRegion region, CompletableFuture<? extends List<? extends IHyperlink>> future) {
        this.viewer = viewer;
        this.document = document;
        this.region = region;
        this.future = future;
        this.documentInitialModificationStamp = DocumentUtil.getDocumentModificationStamp(document);
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public @Nullable String getTypeLabel() {
        return "Open Declaration (resolving...)";
    }

    public @Nullable String getHyperlinkText() {
        return "Open Declaration (resolving...)";
    }

    public void open() {
        this.future.whenComplete((links, ex) -> {
            if (ex != null) {
                LanguageServerPlugin.logError(ex.getLocalizedMessage(), ex);
                return;
            }
            StyledText widget = this.viewer.getTextWidget();
            if (widget == null) {
                return;
            }
            if (links.isEmpty()) {
                LanguageServerPlugin.logWarning("No hyperlink targets resolved for Open Declaration");
                return;
            }
            widget.getDisplay().asyncExec(() -> {
                Object result;
                if (this.isStale()) {
                    return;
                }
                if (links.size() == 1) {
                    ((IHyperlink)links.get(0)).open();
                    return;
                }
                Shell shell = widget.getShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

                    public String getText(@Nullable Object element) {
                        if (element instanceof IHyperlink) {
                            IHyperlink link = (IHyperlink)element;
                            String text = link.getHyperlinkText();
                            return text != null ? text : link.getTypeLabel();
                        }
                        return element == null ? "" : element.toString();
                    }
                });
                dialog.setTitle(Messages.declarationHyperlinkLabel);
                dialog.setMessage("Select a target:");
                dialog.setElements(links.toArray());
                dialog.setMultipleSelection(false);
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IHyperlink) {
                    IHyperlink link = (IHyperlink)result;
                    link.open();
                }
            });
        });
    }

    private boolean isStale() {
        if (System.nanoTime() - this.createdNanos > DEFERRED_OPEN_TIMEOUT_NANOS) {
            return true;
        }
        StyledText widget = this.viewer.getTextWidget();
        if (widget == null || widget.isDisposed()) {
            return true;
        }
        return this.documentInitialModificationStamp != -1L && DocumentUtil.getDocumentModificationStamp(this.document) != this.documentInitialModificationStamp;
    }
}

