/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.List;
import org.commonmark.internal.LinkReferenceDefinitionParser;
import org.commonmark.node.Block;
import org.commonmark.node.DefinitionMap;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private final LinkReferenceDefinitionParser linkReferenceDefinitionParser = new LinkReferenceDefinitionParser();

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.linkReferenceDefinitionParser.parse(line);
    }

    @Override
    public void addSourceSpan(SourceSpan sourceSpan) {
        this.linkReferenceDefinitionParser.addSourceSpan(sourceSpan);
    }

    @Override
    public List<DefinitionMap<?>> getDefinitions() {
        DefinitionMap<LinkReferenceDefinition> map = new DefinitionMap<LinkReferenceDefinition>(LinkReferenceDefinition.class);
        for (LinkReferenceDefinition def : this.linkReferenceDefinitionParser.getDefinitions()) {
            map.putIfAbsent(def.getLabel(), def);
        }
        return List.of(map);
    }

    @Override
    public void closeBlock() {
        for (LinkReferenceDefinition def : this.linkReferenceDefinitionParser.getDefinitions()) {
            this.block.insertBefore(def);
        }
        if (this.linkReferenceDefinitionParser.getParagraphLines().isEmpty()) {
            this.block.unlink();
        } else {
            this.block.setSourceSpans(this.linkReferenceDefinitionParser.getParagraphSourceSpans());
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        SourceLines lines = this.linkReferenceDefinitionParser.getParagraphLines();
        if (!lines.isEmpty()) {
            inlineParser.parse(lines, this.block);
        }
    }

    public SourceLines getParagraphLines() {
        return this.linkReferenceDefinitionParser.getParagraphLines();
    }

    public List<SourceSpan> removeLines(int lines) {
        return this.linkReferenceDefinitionParser.removeLines(lines);
    }
}

