/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.launcher;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.lsp4e.debug.DSPImages;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DSPMainTab
extends AbstractLaunchConfigurationTab {
    private static final int DEFAULT_PORT = 4711;
    private static final String DEFAULT_SERVER = "127.0.0.1";
    private Text debugCommandText = (Text)NullSafetyHelper.lateNonNull();
    private Text debugArgsText = (Text)NullSafetyHelper.lateNonNull();
    private Text jsonText = (Text)NullSafetyHelper.lateNonNull();
    private Button launchDebugServer = (Button)NullSafetyHelper.lateNonNull();
    private Button monitorAdapterLauncherProcessCheckbox = (Button)NullSafetyHelper.lateNonNull();
    private Button connectDebugServer = (Button)NullSafetyHelper.lateNonNull();
    private Text serverHost = (Text)NullSafetyHelper.lateNonNull();
    private Text serverPort = (Text)NullSafetyHelper.lateNonNull();
    private final boolean allowCustomSettingsCheckbox;
    private Button customDebugAdapterCheckbox = (Button)NullSafetyHelper.lateNonNull();
    private Group debugAdapterSettingsGroup = (Group)NullSafetyHelper.lateNonNull();
    private Composite launchParametersGroup = (Composite)NullSafetyHelper.lateNonNull();
    private Button customLaunchParametersCheckbox = (Button)NullSafetyHelper.lateNonNull();

    public DSPMainTab() {
        this(false);
    }

    public DSPMainTab(boolean allowCustomSettingsCheckbox) {
        this.allowCustomSettingsCheckbox = allowCustomSettingsCheckbox;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setFont(parent.getFont());
        this.createVerticalSpacer(comp, 3);
        this.createDebugAdapterComponent(comp);
        this.createDebugJSonComponent(comp);
    }

    private void createDebugAdapterComponent(Composite parent) {
        if (this.allowCustomSettingsCheckbox) {
            this.customDebugAdapterCheckbox = new Button(parent, 32);
            this.customDebugAdapterCheckbox.setText("Override defaults and launch with these debug adapters settings.");
            this.customDebugAdapterCheckbox.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).create());
            this.customDebugAdapterCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        }
        this.debugAdapterSettingsGroup = new Group(parent, 0);
        this.debugAdapterSettingsGroup.setText("Debug Adapter Settings");
        this.debugAdapterSettingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.debugAdapterSettingsGroup.setLayoutData((Object)new GridData(768));
        Label debugText = new Label((Composite)this.debugAdapterSettingsGroup, 0);
        debugText.setText("Launch specific debug adapters using these settings.");
        debugText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.launchDebugServer = new Button((Composite)this.debugAdapterSettingsGroup, 16);
        this.launchDebugServer.setText("&Launch a Debug Server using the following arguments:");
        this.launchDebugServer.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.launchDebugServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.launchDebugServer.setSelection(true);
        Label programLabel = new Label((Composite)this.debugAdapterSettingsGroup, 0);
        programLabel.setText("&Command:");
        programLabel.setLayoutData((Object)new GridData(1));
        this.debugCommandText = new Text((Composite)this.debugAdapterSettingsGroup, 2052);
        this.debugCommandText.setLayoutData((Object)new GridData(768));
        this.debugCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Label argsLabel = new Label((Composite)this.debugAdapterSettingsGroup, 0);
        argsLabel.setText("&Arguments:");
        argsLabel.setLayoutData((Object)new GridData(1));
        this.debugArgsText = new Text((Composite)this.debugAdapterSettingsGroup, 2052);
        this.debugArgsText.setLayoutData((Object)new GridData(768));
        this.debugArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Composite filler = new Composite((Composite)this.debugAdapterSettingsGroup, 0);
        filler.setLayoutData((Object)new GridData(0, 0));
        this.monitorAdapterLauncherProcessCheckbox = new Button((Composite)this.debugAdapterSettingsGroup, 32);
        GridData layoutData = new GridData(16384, -1, true, false);
        this.monitorAdapterLauncherProcessCheckbox.setLayoutData((Object)layoutData);
        this.monitorAdapterLauncherProcessCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.monitorAdapterLauncherProcessCheckbox.setText("Monitor Debug Adapter launcher process");
        this.connectDebugServer = new Button((Composite)this.debugAdapterSettingsGroup, 16);
        this.connectDebugServer.setText("Connect to &running Debug Server using the following arguments:");
        this.connectDebugServer.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.connectDebugServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        Label serverHostLabel = new Label((Composite)this.debugAdapterSettingsGroup, 0);
        serverHostLabel.setText("Server &Host:");
        serverHostLabel.setLayoutData((Object)new GridData(1));
        this.serverHost = new Text((Composite)this.debugAdapterSettingsGroup, 2052);
        this.serverHost.setLayoutData((Object)new GridData(768));
        this.serverHost.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Label serverPortLabel = new Label((Composite)this.debugAdapterSettingsGroup, 0);
        serverPortLabel.setText("Server &Port:");
        serverPortLabel.setLayoutData((Object)new GridData(1));
        this.serverPort = new Text((Composite)this.debugAdapterSettingsGroup, 2052);
        this.serverPort.setLayoutData((Object)new GridData(768));
        this.serverPort.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    private void createDebugJSonComponent(Composite parent) {
        if (this.allowCustomSettingsCheckbox) {
            this.customLaunchParametersCheckbox = new Button(parent, 32);
            this.customLaunchParametersCheckbox.setText("Enable additional Json settings for this launch.");
            this.customLaunchParametersCheckbox.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).create());
            this.customLaunchParametersCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        }
        this.launchParametersGroup = new Group(parent, 0);
        this.launchParametersGroup.setLayout((Layout)new GridLayout());
        this.launchParametersGroup.setLayoutData((Object)new GridData(1808));
        Label jsonLabel = new Label(this.launchParametersGroup, 0);
        jsonLabel.setText("Launch &Parameters (Json):");
        jsonLabel.setLayoutData((Object)new GridData(1));
        this.jsonText = new Text(this.launchParametersGroup, 2626);
        this.jsonText.setLayoutData((Object)new GridData(1808));
        this.jsonText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    private void setEnabled(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Composite c = (Composite)control;
                this.setEnabled(c, enabled);
            } else {
                control.setEnabled(enabled);
            }
            ++n2;
        }
        composite.setEnabled(enabled);
    }

    protected void updateLaunchConfigurationDialog() {
        boolean enableDebugAdapterSettings = this.customDebugAdapterCheckbox == null || this.customDebugAdapterCheckbox.getSelection();
        boolean launch = this.launchDebugServer.getSelection();
        this.setEnabled((Composite)this.debugAdapterSettingsGroup, enableDebugAdapterSettings);
        this.debugCommandText.setEnabled(launch && enableDebugAdapterSettings);
        this.debugArgsText.setEnabled(launch && enableDebugAdapterSettings);
        this.monitorAdapterLauncherProcessCheckbox.setEnabled(launch && enableDebugAdapterSettings);
        this.serverHost.setEnabled(!launch && enableDebugAdapterSettings);
        this.serverPort.setEnabled(!launch && enableDebugAdapterSettings);
        boolean enableLaunchParameterSettings = this.customLaunchParametersCheckbox == null || this.customLaunchParametersCheckbox.getSelection();
        this.setEnabled(this.launchParametersGroup, enableLaunchParameterSettings);
        super.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_DEBUG_ADAPTER", false);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", false);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", "");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Collections.emptyList());
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", DEFAULT_SERVER);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 4711);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", "");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (this.allowCustomSettingsCheckbox) {
                this.customDebugAdapterCheckbox.setSelection(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_DEBUG_ADAPTER", false));
                this.customLaunchParametersCheckbox.setSelection(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", false));
            }
            boolean launch = "launch server".equals(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server"));
            this.launchDebugServer.setSelection(launch);
            this.connectDebugServer.setSelection(!launch);
            this.debugCommandText.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", ""));
            List args = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Collections.emptyList());
            if (args.isEmpty()) {
                this.debugArgsText.setText("");
            } else if (args.size() == 1) {
                this.debugArgsText.setText((String)args.get(0));
            } else {
                this.debugArgsText.setText(String.join((CharSequence)" ", (CharSequence[])args.toArray(String[]::new)));
            }
            this.monitorAdapterLauncherProcessCheckbox.setSelection(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            this.serverHost.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", DEFAULT_SERVER));
            this.serverPort.setText(Integer.toString(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 4711)));
            this.jsonText.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean launch;
        if (this.allowCustomSettingsCheckbox) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_DEBUG_ADAPTER", this.customDebugAdapterCheckbox.getSelection());
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", this.customLaunchParametersCheckbox.getSelection());
        }
        if (launch = this.launchDebugServer.getSelection()) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        } else {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "connect to server");
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", this.getAttributeValueFrom(this.debugCommandText));
        String arg = this.getAttributeValueFrom(this.debugArgsText);
        if (arg == null) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
        } else {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", List.of(arg.split("\\s+")));
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", this.monitorAdapterLauncherProcessCheckbox.getSelection());
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", this.getAttributeValueFrom(this.serverHost));
        String portString = this.getAttributeValueFrom(this.serverPort);
        int port = 4711;
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", port);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", this.getAttributeValueFrom(this.jsonText));
    }

    protected @Nullable String getAttributeValueFrom(Text text) {
        String value = text.getText().trim();
        if (!value.isEmpty()) {
            return value;
        }
        return null;
    }

    public String getName() {
        return "Debug Adapter";
    }

    public @Nullable String getId() {
        return "org.eclipse.lsp4e.debug.launcher.DSPMainTab";
    }

    public @Nullable Image getImage() {
        return DSPImages.get("org.eclipse.lsp4e.debug.debugger_tab.svg");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean enableDebugAdapterSettings;
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean bl = enableDebugAdapterSettings = this.customDebugAdapterCheckbox == null || this.customDebugAdapterCheckbox.getSelection();
        if (enableDebugAdapterSettings) {
            boolean launch = this.launchDebugServer.getSelection();
            if (launch) {
                if (this.getAttributeValueFrom(this.debugCommandText) == null) {
                    this.setMessage("Specify a debug adapter command");
                    return false;
                }
            } else {
                if (this.getAttributeValueFrom(this.serverHost) == null) {
                    this.setMessage("Specify a server host");
                    return false;
                }
                String serverPortVal = this.getAttributeValueFrom(this.serverPort);
                if (serverPortVal != null) {
                    try {
                        int port = Integer.parseInt(serverPortVal);
                        if (port < 1 || port > 65535) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        this.setMessage("Specify a port as an integer in the range 1-65535");
                        return false;
                    }
                }
            }
        }
        boolean enableLaunchParameterSettings = this.customLaunchParametersCheckbox == null || this.customLaunchParametersCheckbox.getSelection();
        return true;
    }
}

