/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class EnumComboEditor
extends ArgumentEditor {
    private CCombo combo;
    Object[] enumConstants;
    Object value;

    public EnumComboEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        super(parent, context, descriptor, item);
        this.enumConstants = descriptor.getType().getEnumConstants();
        this.setFont(item.getFont());
        this.setBackground(item.getBackground());
        this.setLayout((Layout)new FillLayout());
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.combo = new CCombo((Composite)this, 72);
        this.combo.setFont(this.item.getFont());
        this.combo.setBackground(this.item.getBackground());
        Object[] objectArray = this.enumConstants;
        int n = this.enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.combo.add(obj.toString());
            ++n2;
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EnumComboEditor.this.editingDone();
            }
        });
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws SnapshotException {
        this.value = value;
        int i = 0;
        while (i < this.enumConstants.length) {
            if (value.equals(this.enumConstants[i])) {
                this.combo.select(i);
                this.combo.setSelection(new Point(0, 0));
                break;
            }
            ++i;
        }
    }

    private void editingDone() {
        this.value = this.enumConstants[this.combo.getSelectionIndex()];
        this.fireValueChangedEvent(this.value, this);
    }

    public boolean setFocus() {
        return this.combo.setFocus();
    }
}

