/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.ui.ConverterOptions;
import org.eclipse.gmf.internal.graphdef.codegen.ui.ConverterOutcome;
import org.eclipse.gmf.internal.graphdef.codegen.ui.FigureGeneratorOptionsDialog;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GeneratePluginAction
implements IObjectActionDelegate,
IInputValidator {
    private List mySelectedFiles = Collections.EMPTY_LIST;
    private IWorkbenchPart myTargetPart;
    private ConverterOptions myOptions;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.graphdef.codegen.ui.GeneratePluginAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myTargetPart = targetPart;
    }

    public void run(IAction action) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource[] input = this.loadFromSelection((ResourceSet)rs);
        StandaloneGeneratorOptionsDialog dialog = new StandaloneGeneratorOptionsDialog(this.getShell(), null, true, this);
        if (dialog.open() != 0) {
            return;
        }
        String pluginId = dialog.getPluginId();
        StandaloneGenerator.ConfigImpl config = new StandaloneGenerator.ConfigImpl(pluginId, pluginId, dialog.isUseMapMode());
        ConverterOutcome converterOutcome = new ConverterOutcome(this.getOptions(), input);
        IStatus inputCheck = converterOutcome.checkInputAgainstOptions();
        if (!inputCheck.isOK()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Nothing to do", (String)inputCheck.getMessage());
            return;
        }
        StandaloneGenerator generator = new StandaloneGenerator(converterOutcome.getProcessor(), (StandaloneGenerator.Config)config, dialog.getFigureQualifiedNameSwitch());
        generator.setSkipPluginStructure(false);
        new Job(action.getText(), (ResourceSet)rs, generator, converterOutcome, (StandaloneGenerator.Config)config){
            private IContainer myResourcesContainer;
            private final /* synthetic */ ResourceSet val$rs;
            private final /* synthetic */ StandaloneGenerator val$generator;
            private final /* synthetic */ ConverterOutcome val$converterOutcome;
            private final /* synthetic */ StandaloneGenerator.Config val$config;
            {
                this.val$rs = resourceSet;
                this.val$generator = standaloneGenerator;
                this.val$converterOutcome = converterOutcome;
                this.val$config = config;
                super($anonymous0);
                this.setUser(true);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                Iterator it2;
                Throwable throwable2;
                block13: {
                    IStatus iStatus;
                    block12: {
                        IStatus iStatus2;
                        block11: {
                            Iterator it2;
                            IStatus iStatus3;
                            try {
                                try {
                                    this.val$generator.run(monitor);
                                    if (!this.val$generator.getRunStatus().isOK()) {
                                        iStatus2 = this.val$generator.getRunStatus();
                                        Object var4_5 = null;
                                        break block11;
                                    }
                                    URI galleryURI = URI.createPlatformResourceURI((String)this.decideOnDestinationFile("bundled").getFullPath().toString());
                                    URI canvasURI = URI.createPlatformResourceURI((String)this.decideOnDestinationFile("mirrored").getFullPath().toString());
                                    iStatus = this.val$converterOutcome.createResources(this.val$rs, galleryURI, canvasURI);
                                    break block12;
                                }
                                catch (InterruptedException interruptedException) {
                                    iStatus3 = Status.CANCEL_STATUS;
                                    Object var4_7 = null;
                                    it2 = this.val$rs.getResources().iterator();
                                }
                            }
                            catch (Throwable throwable2) {
                                Object var4_8 = null;
                                it2 = this.val$rs.getResources().iterator();
                                break block13;
                            }
                            while (true) {
                                if (!it2.hasNext()) {
                                    return iStatus3;
                                }
                                ((Resource)it2.next()).unload();
                            }
                        }
                        Iterator it2 = this.val$rs.getResources().iterator();
                        while (it2.hasNext()) {
                            ((Resource)it2.next()).unload();
                        }
                        return iStatus2;
                    }
                    Object var4_6 = null;
                    Iterator it2 = this.val$rs.getResources().iterator();
                    while (it2.hasNext()) {
                        ((Resource)it2.next()).unload();
                    }
                    return iStatus;
                }
                while (true) {
                    if (!it2.hasNext()) {
                        throw throwable2;
                    }
                    ((Resource)it2.next()).unload();
                }
            }

            private IFile decideOnDestinationFile(String baseName) {
                Path basePath = new Path(baseName);
                IFile resultFile = this.getResourcesContainer().getFile(basePath.addFileExtension("gmfgraph"));
                int i = 1;
                while (resultFile.exists()) {
                    resultFile = this.getResourcesContainer().getFile(new Path(String.valueOf(basePath.lastSegment()) + String.valueOf(i)).addFileExtension("gmfgraph"));
                    ++i;
                }
                return resultFile;
            }

            private IContainer getResourcesContainer() {
                if (this.myResourcesContainer == null) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(this.val$config.getPluginID());
                    if (!$assertionsDisabled && !p.exists()) {
                        throw new AssertionError();
                    }
                    this.myResourcesContainer = p;
                    IFolder modelsFolder = p.getFolder("models");
                    if (!modelsFolder.exists()) {
                        try {
                            modelsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            this.myResourcesContainer = modelsFolder;
                        }
                        catch (CoreException coreException) {}
                    }
                }
                return this.myResourcesContainer;
            }
        }.schedule();
    }

    private Resource[] loadFromSelection(ResourceSet rs) {
        Resource[] rv = new Resource[this.mySelectedFiles.size()];
        int i = 0;
        Iterator it = this.mySelectedFiles.iterator();
        while (it.hasNext()) {
            IFile next = (IFile)it.next();
            rv[i] = rs.getResource(URI.createPlatformResourceURI((String)next.getFullPath().toString()), true);
            ++i;
        }
        return rv;
    }

    public String isValid(String newText) {
        IStatus s = JavaConventions.validatePackageName((String)newText);
        if (s.isOK()) {
            return null;
        }
        return s.getMessage();
    }

    private Shell getShell() {
        return this.myTargetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelectedFiles = new ArrayList(5);
        if (selection instanceof IStructuredSelection) {
            this.mySelectedFiles.addAll(((IStructuredSelection)selection).toList());
        }
    }

    private ConverterOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = this.loadOptions();
        }
        return this.myOptions;
    }

    private ConverterOptions loadOptions() {
        ConverterOptions options = new ConverterOptions();
        options.needMirroredCanvas = true;
        options.needMirroredGalleries = true;
        return options;
    }

    private static class StandaloneGeneratorOptionsDialog
    extends FigureGeneratorOptionsDialog {
        private IInputValidator pluginIdValidator;
        private Text pluginIdText;
        private String pluginId;
        private final boolean shouldWarnLiteVerstionDoesNotSupportMapMode;

        public StandaloneGeneratorOptionsDialog(Shell parentShell, String initialPluginId, boolean initialUseRuntimeFigures, IInputValidator pluginIdValidator) {
            this(parentShell, initialPluginId, initialUseRuntimeFigures, false, pluginIdValidator);
        }

        public StandaloneGeneratorOptionsDialog(Shell parentShell, String initialPluginId, boolean initialUseRuntimeFigures, boolean initialUseMapMode, IInputValidator pluginIdValidator) {
            super(parentShell, "Figure Gallery Generator", initialUseRuntimeFigures, initialUseMapMode);
            this.pluginId = initialPluginId;
            if (this.pluginId == null) {
                this.pluginId = "";
            }
            this.pluginIdValidator = pluginIdValidator;
            this.shouldWarnLiteVerstionDoesNotSupportMapMode = Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
        }

        protected void createControls(Composite result) {
            Label label = new Label(result, 64);
            label.setText("Please specify the name of plug-in/main package");
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            this.pluginIdText = new Text(result, 2052);
            this.pluginIdText.setLayoutData((Object)new GridData(768));
            this.pluginIdText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ StandaloneGeneratorOptionsDialog this$1;
                {
                    this.this$1 = standaloneGeneratorOptionsDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validateInput();
                }
            });
            super.createControls(result);
        }

        protected void validateInput() {
            String errorMessage = null;
            if (this.pluginIdValidator != null) {
                errorMessage = this.pluginIdValidator.isValid(this.pluginIdText.getText());
            }
            this.setErrorMessage(errorMessage);
        }

        protected void warnLiteVerstionDoesNotSupportMapMode() {
            if (this.shouldWarnLiteVerstionDoesNotSupportMapMode) {
                super.warnLiteVerstionDoesNotSupportMapMode();
            }
        }

        protected void okPressed() {
            this.pluginId = this.pluginIdText.getText();
            super.okPressed();
        }

        public String getPluginId() {
            return this.pluginId;
        }
    }
}

