/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.clipboard.AWTViewImageTransferable;

public class AWTClipboardHelper {
    private static final boolean IMAGE_COPY_SUPPORTED;
    private static AWTClipboardHelper INSTANCE;
    private Clipboard awtClipboard;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        IMAGE_COPY_SUPPORTED = System.getProperty("os.name").toUpperCase().startsWith("WIN");
        INSTANCE = new AWTClipboardHelper();
    }

    public static AWTClipboardHelper getInstance() {
        return INSTANCE;
    }

    private AWTClipboardHelper() {
        if (this.isImageCopySupported()) {
            this.awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    public final boolean isImageCopySupported() {
        return IMAGE_COPY_SUPPORTED;
    }

    public boolean hasCustomData() {
        if (!$assertionsDisabled && !this.isImageCopySupported()) {
            throw new AssertionError();
        }
        Transferable transferable = this.getClipboard().getContents(null);
        if (transferable != null) {
            DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
            int i = 0;
            while (i < dataFlavors.length) {
                if (dataFlavors[i].equals(AWTViewImageTransferable.AWTCUSTOMDATAFLAVOR)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public CustomData getCustomData() {
        if (!$assertionsDisabled && !this.isImageCopySupported()) {
            throw new AssertionError();
        }
        Transferable transferable = this.getClipboard().getContents(null);
        if (transferable == null) {
            return null;
        }
        if (!this.hasCustomData()) {
            return null;
        }
        CustomData data = null;
        try {
            data = (CustomData)transferable.getTransferData(AWTViewImageTransferable.AWTCUSTOMDATAFLAVOR);
        }
        catch (UnsupportedFlavorException e) {
            DiagramUIRenderPlugin diagramUIRenderPlugin = DiagramUIRenderPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIRenderPlugin, (String)DiagramUIRenderDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"getCustomData", (Throwable)e);
        }
        catch (IOException e) {
            DiagramUIRenderPlugin diagramUIRenderPlugin = DiagramUIRenderPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIRenderPlugin, (String)DiagramUIRenderDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"getCustomData", (Throwable)e);
        }
        return data;
    }

    public void copyToClipboard(CustomData data, Image image) {
        if (!$assertionsDisabled && !this.isImageCopySupported()) {
            throw new AssertionError();
        }
        this.getClipboard().setContents(new AWTViewImageTransferable((ICustomData)data, image), null);
    }

    private Clipboard getClipboard() {
        return this.awtClipboard;
    }
}

