/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Collection;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.lite.setup.LibraryConstrainedSetup;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.SessionSetup;

public class DiagramNodeCloneMoveTest
extends GeneratedCanvasTest {
    public DiagramNodeCloneMoveTest(String name) {
        super(name);
    }

    protected SessionSetup createDefaultSetup() {
        return LibraryConstrainedSetup.getInstance();
    }

    public void testClone() throws Exception {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeB.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeB.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        Node nodeBInstance = this.getCanvasInstance().getNodeB();
        Diagram diagram = nodeBInstance.getDiagram();
        Node clonedB = this.checkClone(nodeBInstance, (View)diagram, (View)diagram, nodeB, nodeB);
        Node level1Child = this.createNodeIndirect(childNode, (View)this.getCanvasInstance().getNodeBCompartment());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Level1 ChildNode was not created", (Object)level1Child);
        Node clonedLevel1Child = this.checkClone(level1Child, (View)this.getCanvasInstance().getNodeBCompartment(), (View)this.getCanvasInstance().getNodeBCompartment(), childNode, childNode);
        Node clonedBCompartment = (Node)DiagramNodeCloneMoveTest.findChildView((View)clonedB, (GenCommonBase)genCompartment);
        this.checkClone(clonedLevel1Child, (View)clonedBCompartment, (View)this.getCanvasInstance().getNodeBCompartment(), childNode, childNode);
    }

    public void testMove() throws Exception {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeB.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeB.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        Node nodeBInstance = this.getCanvasInstance().getNodeB();
        Diagram diagram = nodeBInstance.getDiagram();
        Node clonedB = this.checkClone(nodeBInstance, (View)diagram, (View)diagram, nodeB, nodeB);
        Node level1Child = this.createNodeIndirect(childNode, (View)this.getCanvasInstance().getNodeBCompartment());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Level1 ChildNode was not created", (Object)level1Child);
        Node clonedBCompartment = (Node)DiagramNodeCloneMoveTest.findChildView((View)clonedB, (GenCommonBase)genCompartment);
        this.checkMove(level1Child, (View)clonedBCompartment, (View)this.getCanvasInstance().getNodeBCompartment(), childNode, childNode);
    }

    public void testCloneWithVisualIDChange() throws Exception {
        GenNode nodeA = this.getSetup().getGenModel().getNodeA();
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        GenCompartment genCompartment = (GenCompartment)nodeA.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Node A has no compartments", (Object)genCompartment);
        GenNode nodeBAsChildOfA = (GenNode)genCompartment.getChildNodes().get(0);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Node A compartment has no children", (Object)nodeBAsChildOfA);
        DiagramNodeCloneMoveTest.assertEquals((String)"Incorrect child", (String)nodeB.getModelFacet().getMetaClass().getEcoreClass().getName(), (String)nodeBAsChildOfA.getModelFacet().getMetaClass().getEcoreClass().getName());
        Node nodeAInstance = this.getCanvasInstance().getNodeA();
        Node compartmentA = (Node)DiagramNodeCloneMoveTest.findChildView((View)nodeAInstance, (GenCommonBase)genCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Compartment not found", (Object)compartmentA);
        Node nodeBInstance = this.getCanvasInstance().getNodeB();
        Diagram diagram = nodeBInstance.getDiagram();
        this.checkClone(nodeBInstance, (View)compartmentA, (View)diagram, nodeB, nodeBAsChildOfA);
    }

    public void testMoveWithVisualIDChange() throws Exception {
        GenNode nodeA = this.getSetup().getGenModel().getNodeA();
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        GenCompartment genCompartment = (GenCompartment)nodeA.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Node A has no compartments", (Object)genCompartment);
        GenNode nodeBAsChildOfA = (GenNode)genCompartment.getChildNodes().get(0);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Node A compartment has no children", (Object)nodeBAsChildOfA);
        DiagramNodeCloneMoveTest.assertSame((String)"Incorrect child", (Object)nodeB.getModelFacet().getMetaClass(), (Object)nodeBAsChildOfA.getModelFacet().getMetaClass());
        Node nodeAInstance = this.getCanvasInstance().getNodeA();
        Node compartmentA = (Node)DiagramNodeCloneMoveTest.findChildView((View)nodeAInstance, (GenCommonBase)genCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Compartment not found", (Object)compartmentA);
        Node nodeBInstance = this.getCanvasInstance().getNodeB();
        Diagram diagram = nodeBInstance.getDiagram();
        this.checkMove(nodeBInstance, (View)compartmentA, (View)diagram, nodeB, nodeBAsChildOfA);
    }

    private Node checkClone(Node node, View newContainer, View originalContainer, GenNode originalGenNode, GenNode expectedGenNode) {
        DiagramNodeCloneMoveTest.assertEquals((int)originalGenNode.getVisualID(), (int)Integer.parseInt(node.getType()));
        EditPart nodeEP = this.findEditPart((View)node);
        DiagramNodeCloneMoveTest.assertNotNull((Object)nodeEP);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeEP.isActive());
        this.checkContainment((View)node, originalContainer, originalGenNode.getModelFacet().getContainmentMetaFeature(), originalGenNode.getModelFacet().getChildMetaFeature());
        Node clone = this.cloneOrMoveNode(node, newContainer, true);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Clone command returned null", (Object)clone);
        DiagramNodeCloneMoveTest.assertEquals((int)expectedGenNode.getVisualID(), (int)Integer.parseInt(clone.getType()));
        EditPart clonedEP = this.findEditPart((View)clone);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find the edit part for the cloned node", (Object)clonedEP);
        DiagramNodeCloneMoveTest.assertTrue((boolean)clonedEP.isActive());
        this.checkContainment((View)clone, newContainer, expectedGenNode.getModelFacet().getContainmentMetaFeature(), expectedGenNode.getModelFacet().getChildMetaFeature());
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeEP.isActive());
        this.checkContainment((View)node, originalContainer, originalGenNode.getModelFacet().getContainmentMetaFeature(), originalGenNode.getModelFacet().getChildMetaFeature());
        return clone;
    }

    private Node checkMove(Node node, View newContainer, View originalContainer, GenNode originalGenNode, GenNode expectedGenNode) {
        DiagramNodeCloneMoveTest.assertEquals((int)originalGenNode.getVisualID(), (int)Integer.parseInt(node.getType()));
        EditPart nodeEP = this.findEditPart((View)node);
        DiagramNodeCloneMoveTest.assertNotNull((Object)nodeEP);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeEP.isActive());
        this.checkContainment((View)node, originalContainer, originalGenNode.getModelFacet().getContainmentMetaFeature(), originalGenNode.getModelFacet().getChildMetaFeature());
        Node moved = this.cloneOrMoveNode(node, newContainer, false);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Move command returned null", (Object)moved);
        DiagramNodeCloneMoveTest.assertEquals((int)expectedGenNode.getVisualID(), (int)Integer.parseInt(moved.getType()));
        EditPart movedEP = this.findEditPart((View)moved);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find the edit part for the cloned node", (Object)movedEP);
        DiagramNodeCloneMoveTest.assertTrue((boolean)movedEP.isActive());
        this.checkContainment((View)moved, newContainer, expectedGenNode.getModelFacet().getContainmentMetaFeature(), expectedGenNode.getModelFacet().getChildMetaFeature());
        DiagramNodeCloneMoveTest.assertFalse((boolean)nodeEP.isActive());
        DiagramNodeCloneMoveTest.assertFalse((boolean)originalContainer.getChildren().contains((Object)node));
        return moved;
    }

    private void checkContainment(View child, View parent, GenFeature containmentMetaFeature, GenFeature childMetaFeature) {
        DiagramNodeCloneMoveTest.assertSame((String)"Incorrect notation-model containment", (Object)parent, (Object)child.eContainer());
        EObject childEObject = child.getElement();
        if (parent == null) {
            DiagramNodeCloneMoveTest.assertNull((String)"Incorrect domain-model containment", (Object)childEObject.eContainer());
            return;
        }
        EObject parentEObject = parent.getElement();
        DiagramNodeCloneMoveTest.assertSame((String)"Incorrect domain-model containment", (Object)parentEObject, (Object)childEObject.eContainer());
        EStructuralFeature containmentFeature = parentEObject.eClass().getEStructuralFeature(containmentMetaFeature.getEcoreFeature().getName());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find containment feature", (Object)containmentFeature);
        DiagramNodeCloneMoveTest.assertSame((String)"Incorrect domain-model containment feature", (Object)containmentFeature, (Object)childEObject.eContainmentFeature());
        if (childMetaFeature != null) {
            EStructuralFeature childFeature = parentEObject.eClass().getEStructuralFeature(childMetaFeature.getEcoreFeature().getName());
            DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find child feature", (Object)childFeature);
            DiagramNodeCloneMoveTest.assertTrue((String)"Child feature not set", (boolean)((Collection)parentEObject.eGet(childFeature)).contains(childEObject));
        }
    }

    private Node cloneOrMoveNode(Node node, View container, boolean isCloneNotMove) {
        Object[] resultHolder;
        block6: {
            resultHolder = new Object[1];
            EditPart containerEP = this.findEditPart(container);
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getEventType() == 3) {
                        resultHolder[0] = msg.getNewValue();
                    }
                }

                public boolean isAdapterForType(Object type) {
                    return true;
                }
            };
            EditPart nodeEP = this.findEditPart((View)node);
            DiagramNodeCloneMoveTest.assertNotNull((String)"No edit part available for the node being cloned", (Object)nodeEP);
            org.eclipse.gef.commands.Command cmd = null;
            if (!isCloneNotMove) {
                ChangeBoundsRequest orphanRequest = new ChangeBoundsRequest((Object)"orphan");
                orphanRequest.setLocation(new Point(0, 0));
                orphanRequest.setEditParts(nodeEP);
                cmd = nodeEP.getCommand((Request)orphanRequest);
            }
            ChangeBoundsRequest cloneRequest = new ChangeBoundsRequest((Object)(isCloneNotMove ? "clone" : "add children"));
            cloneRequest.setLocation(new Point(0, 0));
            cloneRequest.setEditParts(nodeEP);
            cmd = this.merge(cmd, containerEP.getCommand((Request)cloneRequest));
            Assert.assertNotNull((String)"No command is available for request", (Object)cmd);
            container.eAdapters().add((Object)adapter);
            try {
                try {
                    this.execute(cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Node creation failure: " + e.getLocalizedMessage()));
                    container.eAdapters().remove((Object)adapter);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                container.eAdapters().remove((Object)adapter);
                throw throwable;
            }
            container.eAdapters().remove((Object)adapter);
        }
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to create notation model Node", (boolean)(resultHolder[0] instanceof Node));
        return (Node)resultHolder[0];
    }

    protected Node createNodeIndirect(GenNode nodeType, View notationContainer) {
        Object[] resultHolder;
        block6: {
            resultHolder = new Object[1];
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getEventType() == 3) {
                        resultHolder[0] = msg.getNewValue();
                    }
                }

                public boolean isAdapterForType(Object type) {
                    return true;
                }
            };
            EObject container = notationContainer.getElement();
            DiagramNodeCloneMoveTest.assertNotNull((Object)container);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)container);
            EPackage ePackage = container.eClass().getEPackage();
            EObject createdElement = ePackage.getEFactoryInstance().create((EClass)ePackage.getEClassifier(nodeType.getDomainMetaClass().getEcoreClass().getName()));
            CompoundCommand compoundCommand = new CompoundCommand();
            EStructuralFeature containmentFeature = container.eClass().getEStructuralFeature(nodeType.getModelFacet().getContainmentMetaFeature().getEcoreFeature().getName());
            DiagramNodeCloneMoveTest.assertNotNull((Object)containmentFeature);
            compoundCommand.append(AddCommand.create((EditingDomain)editingDomain, (Object)container, (Object)containmentFeature, (Object)createdElement));
            EStructuralFeature childFeature = container.eClass().getEStructuralFeature(nodeType.getModelFacet().getChildMetaFeature().getEcoreFeature().getName());
            if (childFeature != null && !childFeature.isDerived() && childFeature != containmentFeature) {
                compoundCommand.append(AddCommand.create((EditingDomain)editingDomain, (Object)container, (Object)childFeature, (Object)createdElement));
            }
            DiagramNodeCloneMoveTest.assertTrue((boolean)compoundCommand.canExecute());
            notationContainer.eAdapters().add((Object)adapter);
            try {
                try {
                    new EMFCommandOperation(editingDomain, (Command)compoundCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Node creation failure: " + e.getLocalizedMessage()));
                    notationContainer.eAdapters().remove((Object)adapter);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                notationContainer.eAdapters().remove((Object)adapter);
                throw throwable;
            }
            notationContainer.eAdapters().remove((Object)adapter);
        }
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to indirectly create notation model Node", (boolean)(resultHolder[0] instanceof Node));
        return (Node)resultHolder[0];
    }

    private org.eclipse.gef.commands.Command merge(org.eclipse.gef.commands.Command one, org.eclipse.gef.commands.Command another) {
        if (one == null) {
            return another;
        }
        if (another == null) {
            return one;
        }
        return one.chain(another);
    }

    public void testNodeMultiplicity() throws Exception {
        Node writer = this.getCanvasInstance().getNodeA();
        final Node book = this.getCanvasInstance().getNodeB();
        GenNode writerGenNode = this.getSetup().getGenModel().getNodeA();
        GenCompartment brochuresCompartment = (GenCompartment)writerGenNode.getCompartments().get(0);
        final GenNode brochuresGenNode = (GenNode)brochuresCompartment.getChildNodes().get(0);
        final View writerCompartment = DiagramNodeCloneMoveTest.findChildView((View)writer, (GenCommonBase)brochuresCompartment);
        this.cloneOrMoveNode(book, writerCompartment, true);
        final Node secondBrochure = this.createNode((GenCommonBase)brochuresGenNode, writerCompartment);
        this.shouldFail("Should not be possible to create a third node here", new Runnable(){

            public void run() {
                DiagramNodeCloneMoveTest.this.createNode((GenCommonBase)brochuresGenNode, writerCompartment);
            }
        });
        this.shouldFail("Should not be possible to clone a third node here", new Runnable(){

            public void run() {
                DiagramNodeCloneMoveTest.this.cloneOrMoveNode(secondBrochure, writerCompartment, true);
            }
        });
        this.shouldFail("Should not be possible to move a third node here", new Runnable(){

            public void run() {
                DiagramNodeCloneMoveTest.this.cloneOrMoveNode(book, writerCompartment, false);
            }
        });
    }

    public void testLinkMultiplicity() throws Exception {
        final Node writer = this.getCanvasInstance().getNodeA();
        final Node book = this.getCanvasInstance().getNodeB();
        final GenLink opinionGenLink = this.getSetup().getGenModel().getLinkC();
        Edge opinion1 = this.getCanvasInstance().getLinkByClass();
        Edge opinion2 = this.createLink(opinionGenLink, (View)writer, (View)book);
        DiagramNodeCloneMoveTest.assertNotNull((Object)opinion1);
        DiagramNodeCloneMoveTest.assertNotNull((Object)opinion2);
        this.shouldFail("Should not be possible to create a third link", new Runnable(){

            public void run() {
                Edge opinion3 = DiagramNodeCloneMoveTest.this.createLink(opinionGenLink, (View)writer, (View)book);
                DiagramNodeCloneMoveTest.assertNotNull((Object)opinion3);
            }
        });
    }

    public void testLinkTargetFeatureInverseMultiplicity() throws Exception {
        Node writer1 = this.getCanvasInstance().getNodeA();
        final Node book = this.getCanvasInstance().getNodeB();
        final GenLink opinionGenLink = this.getSetup().getGenModel().getLinkC();
        Edge opinion1 = this.getCanvasInstance().getLinkByClass();
        DiagramNodeCloneMoveTest.assertNotNull((Object)opinion1);
        Node writer2 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)writer1.getDiagram());
        Edge opinion2 = this.createLink(opinionGenLink, (View)writer2, (View)book);
        DiagramNodeCloneMoveTest.assertNotNull((Object)opinion2);
        final Node writer3 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)writer1.getDiagram());
        this.shouldFail("Should not be possible to create a third incoming link to book: Book::opinions multiplicity is 2", new Runnable(){

            public void run() {
                Edge opinion3 = DiagramNodeCloneMoveTest.this.createLink(opinionGenLink, (View)writer3, (View)book);
                DiagramNodeCloneMoveTest.assertNotNull((Object)opinion3);
            }
        });
    }

    private void shouldFail(String msg, Runnable r) {
        try {
            r.run();
        }
        catch (AssertionFailedError assertionFailedError) {
            return;
        }
        DiagramNodeCloneMoveTest.fail((String)msg);
    }

    public void testCompartmentCollapsibility() throws Exception {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeB.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeB.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        Node nodeBInstance = this.createNode((GenCommonBase)nodeB, (View)this.getDiagram());
        Node nodeBCompartment = (Node)DiagramNodeCloneMoveTest.findChildView((View)nodeBInstance, (GenCommonBase)genCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find the compartment", (Object)nodeBCompartment);
        DrawerStyle drawerStyle = (DrawerStyle)nodeBCompartment.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Drawer style not added automatically", (Object)drawerStyle);
        DiagramNodeCloneMoveTest.assertFalse((String)"Compartment should be expanded by default", (boolean)drawerStyle.isCollapsed());
        Node level1Child = this.createNode((GenCommonBase)childNode, (View)nodeBCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Child not created", (Object)level1Child);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeBCompartment.getChildren().contains((Object)level1Child));
        EditPart compartmentEP = this.findEditPart((View)nodeBCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Edit part for compartment is missing", (Object)compartmentEP);
        EditPart childEP = this.findEditPart((View)level1Child);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Edit part for child is missing", (Object)childEP);
        DiagramNodeCloneMoveTest.assertTrue((String)"Edit part for child is inactive", (boolean)childEP.isActive());
        DiagramNodeCloneMoveTest.assertSame((String)"Unexpected parent of the child edit part", (Object)compartmentEP, (Object)childEP.getParent());
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)drawerStyle);
        Command command = SetCommand.create((EditingDomain)domain, (Object)drawerStyle, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)Boolean.TRUE);
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to obtain command to collapse the compartment", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        DiagramNodeCloneMoveTest.assertTrue((String)"Compartment failed to collapse", (boolean)drawerStyle.isCollapsed());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Collapsing compartment should not have removed the view", (Object)level1Child.eResource());
        DiagramNodeCloneMoveTest.assertFalse((String)"Collapsing compartment should have removed the child edit part", (boolean)childEP.isActive());
        childEP = this.findEditPart((View)level1Child);
        DiagramNodeCloneMoveTest.assertNull((String)"Collapsing compartment should have made the child edit part go away", (Object)childEP);
        command = SetCommand.create((EditingDomain)domain, (Object)drawerStyle, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)Boolean.FALSE);
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to obtain command to expand the compartment", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        DiagramNodeCloneMoveTest.assertFalse((String)"Compartment failed to expand", (boolean)drawerStyle.isCollapsed());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Expanding compartment should not have done anything to the view", (Object)level1Child.eResource());
        childEP = this.findEditPart((View)level1Child);
        DiagramNodeCloneMoveTest.assertTrue((String)"Expanding compartment should have made the child edit part to reappear", (boolean)childEP.isActive());
    }

    public void testCompartmentExpandsOnAddingToIt() throws Exception {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no compartments", (nodeB.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)nodeB.getCompartments().get(0);
        DiagramNodeCloneMoveTest.assertTrue((String)"Incorrect Setup: passed node has no children", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        Node nodeBInstance = this.createNode((GenCommonBase)nodeB, (View)this.getDiagram());
        Node nodeBCompartment = (Node)DiagramNodeCloneMoveTest.findChildView((View)nodeBInstance, (GenCommonBase)genCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to find the compartment", (Object)nodeBCompartment);
        DrawerStyle drawerStyle = (DrawerStyle)nodeBCompartment.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        DiagramNodeCloneMoveTest.assertNotNull((String)"Drawer style not added automatically", (Object)drawerStyle);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)drawerStyle);
        Command command = SetCommand.create((EditingDomain)domain, (Object)drawerStyle, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)Boolean.TRUE);
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to obtain command to collapse the compartment", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        DiagramNodeCloneMoveTest.assertTrue((String)"Compartment failed to collapse", (boolean)drawerStyle.isCollapsed());
        Node child = this.createNode((GenCommonBase)childNode, (View)nodeBCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Child not created", (Object)child);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeBCompartment.getChildren().contains((Object)child));
        DiagramNodeCloneMoveTest.assertFalse((String)"Compartment failed to expand automatically on adding a new child", (boolean)drawerStyle.isCollapsed());
        Node nodeBClone = this.cloneOrMoveNode(nodeBInstance, (View)this.getDiagram(), true);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Failed to clone node", (Object)nodeBClone);
        View compartmentClone = DiagramNodeCloneMoveTest.findChildView((View)nodeBClone, (GenCommonBase)genCompartment);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Cloning node failed to clone its child compartment", (Object)compartmentClone);
        Node childClone = (Node)DiagramNodeCloneMoveTest.findChildView((View)compartmentClone, (GenCommonBase)childNode);
        command = SetCommand.create((EditingDomain)domain, (Object)drawerStyle, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)Boolean.TRUE);
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to obtain command to collapse the compartment", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        DiagramNodeCloneMoveTest.assertTrue((String)"Compartment failed to collapse", (boolean)drawerStyle.isCollapsed());
        Node anotherChild = this.cloneOrMoveNode(childClone, (View)nodeBCompartment, true);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Clone not created", (Object)anotherChild);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeBCompartment.getChildren().contains((Object)anotherChild));
        DiagramNodeCloneMoveTest.assertFalse((String)"Compartment failed to expand automatically on adding a new child", (boolean)drawerStyle.isCollapsed());
        command = SetCommand.create((EditingDomain)domain, (Object)drawerStyle, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)Boolean.TRUE);
        DiagramNodeCloneMoveTest.assertTrue((String)"Failed to obtain command to collapse the compartment", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        DiagramNodeCloneMoveTest.assertTrue((String)"Compartment failed to collapse", (boolean)drawerStyle.isCollapsed());
        anotherChild = this.cloneOrMoveNode(childClone, (View)nodeBCompartment, false);
        DiagramNodeCloneMoveTest.assertNotNull((String)"Clone not created", (Object)anotherChild);
        DiagramNodeCloneMoveTest.assertTrue((boolean)nodeBCompartment.getChildren().contains((Object)anotherChild));
        DiagramNodeCloneMoveTest.assertFalse((String)"Compartment failed to expand automatically on adding a new child", (boolean)drawerStyle.isCollapsed());
    }
}

