/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class CopyUtils {
    public static void copyID(EObject source, EObject target) {
        CopyUtils.copyID(source, target, "");
    }

    public static void copyID(EObject source, EObject target, String prefix) {
        Resource resourceSource = source.eResource();
        Resource resourceTarget = target.eResource();
        if (resourceSource instanceof XMLResource && resourceTarget instanceof XMLResource) {
            XMLResource xmlResSource = (XMLResource)resourceSource;
            XMLResource xmlResTarget = (XMLResource)resourceTarget;
            String id = String.valueOf(prefix) + xmlResSource.getID(source);
            int counter = 0;
            String uniqueID = id;
            while (xmlResTarget.getIDToEObjectMap().containsKey(uniqueID)) {
                uniqueID = String.valueOf(id) + counter;
                ++counter;
            }
            xmlResTarget.setID(target, uniqueID);
        }
    }

    public static ValueSpecification copyDefaultValue(Property source, Property target) {
        ValueSpecification value = source.getDefaultValue();
        if (value != null) {
            ValueSpecification newValue = target.createDefaultValue(value.getName(), value.getType(), value.eClass());
            return CopyUtils.copyValue(value, newValue);
        }
        return null;
    }

    public static void copyFeatureModifiers(Feature source, Feature target) {
        target.setIsStatic(source.isStatic());
        target.setIsLeaf(source.isLeaf());
    }

    public static void copyMultElemModifiers(MultiplicityElement source, MultiplicityElement target) {
        target.setIsOrdered(source.isOrdered());
        target.setIsUnique(source.isUnique());
        target.setLower(source.getLower());
        target.setUpper(source.getUpper());
    }

    public static ValueSpecification copyValue(ValueSpecification value, Slot target) {
        ValueSpecification newValue = target.createValue(value.getName(), value.getType(), value.eClass());
        return CopyUtils.copyValue(value, newValue);
    }

    public static ValueSpecification copyValue(ValueSpecification smValue, ValueSpecification tmValue) {
        if (smValue instanceof OpaqueExpression) {
            OpaqueExpression oeValue = (OpaqueExpression)smValue;
            OpaqueExpression noeValue = (OpaqueExpression)tmValue;
            for (String language : oeValue.getLanguages()) {
                noeValue.getLanguages().add((Object)language);
            }
            for (String body : oeValue.getBodies()) {
                noeValue.getBodies().add((Object)body);
            }
        } else if (smValue instanceof LiteralString) {
            ((LiteralString)tmValue).setValue(((LiteralString)smValue).getValue());
        } else if (smValue instanceof LiteralInteger) {
            ((LiteralInteger)tmValue).setValue(((LiteralInteger)smValue).getValue());
        } else if (smValue instanceof LiteralUnlimitedNatural) {
            ((LiteralUnlimitedNatural)tmValue).setValue(((LiteralUnlimitedNatural)smValue).getValue());
        } else if (smValue instanceof LiteralBoolean) {
            ((LiteralBoolean)tmValue).setValue(((LiteralBoolean)smValue).booleanValue());
        } else {
            boolean cfr_ignored_0 = smValue instanceof LiteralNull;
        }
        return tmValue;
    }
}

