/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen2;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.MethodInfo;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.SyncInformation;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Messages;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppModelElementsCreator;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.LocateCppProject;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppParameter;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.C_CppPackage;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;

public class CppLangCodegen
implements ILangCodegen2 {
    protected ModelElementsCreator creator = null;
    protected IProject lastProject = null;

    public String getDescription() {
        return Messages.C_CppLangCodegen_GeneratorDesc;
    }

    public boolean isEligible(Element modelElement) {
        Package nearestPackage;
        if (modelElement instanceof PackageableElement && (nearestPackage = modelElement.getNearestPackage()) != null) {
            for (Profile profile : nearestPackage.getAllAppliedProfiles()) {
                if (!C_CppPackage.eINSTANCE.getName().equals(profile.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getSuffix(ILangCodegen.FILE_KIND fileKind) {
        if (fileKind == ILangCodegen.FILE_KIND.BODY) {
            return CppCodeGenUtils.getBodySuffix();
        }
        return CppCodeGenUtils.getHeaderSuffix();
    }

    public void generateCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
        this.manageCreator(project, (Element)element);
        this.creator.createPackageableElement(element, monitor);
    }

    public void cleanCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
        this.manageCreator(project, (Element)element);
        IFolder folder = project.getFolder(GenUtils.getSourceFolder((Element)element));
        this.creator.cleanUntouched(folder, monitor);
    }

    public String getFileName(IProject project, NamedElement element) {
        this.manageCreator(project, (Element)element);
        return this.creator.getFileName(element);
    }

    public IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        return LocateCppProject.getTargetProject(pe, createIfMissing);
    }

    protected void manageCreator(IProject project, Element element) {
        if (project == null && element instanceof PackageableElement) {
            project = this.getTargetProject((PackageableElement)element, false);
        }
        if (this.creator == null || project != this.lastProject) {
            this.lastProject = project;
            this.creator = new CppModelElementsCreator(project);
        }
    }

    public SyncInformation getSyncInformation(String methodName, String body) {
        return null;
    }

    public MethodInfo getMethodInfo(NamedElement operationOrBehavior) {
        MethodInfo mi = new MethodInfo(operationOrBehavior.getName());
        EList parameters = null;
        if (operationOrBehavior instanceof Operation) {
            parameters = ((Operation)operationOrBehavior).getOwnedParameters();
        } else if (operationOrBehavior instanceof Behavior) {
            parameters = ((Behavior)operationOrBehavior).getOwnedParameters();
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                mi.addParameterType(CppParameter.CppParameterForCDT(parameter).toString());
            }
        }
        return mi;
    }
}

