/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EReferencePartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ISubBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping.AbstractEMFTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class EReferencePartTemplateMapper
extends AbstractEMFTemplateToStructureMapper<EReferencePartTemplate> {
    public EReferencePartTemplateMapper() {
        super(TEMPLATE_EPACKAGE.getEReferencePartTemplate(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, EReferencePartTemplate referencePartTemplate, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!referencePartTemplate.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        ArrayList returnedElements = new ArrayList();
        EList matchingElements = referencePartTemplate.getEReferenceValues(semanticModelElement);
        if (matchingElements.isEmpty()) {
            return null;
        }
        Title title = null;
        if (referencePartTemplate.isGenerate() && referencePartTemplate.isGenerateTitle()) {
            title = STRUCTURE_EFACTORY.createTitle();
            title.setTitle(referencePartTemplate.buildPartTemplateTitle(null));
            returnedElements.add(expectedReturnedClass.cast(title));
        }
        for (ISubBodyPartTemplate currentObjectPartTemplate : referencePartTemplate.getSubBodyPartTemplates()) {
            for (EObject currentEObject : matchingElements) {
                List<BodyPart> result = mappingService.map((EObject)currentObjectPartTemplate, currentEObject, BodyPart.class);
                if (result == null) continue;
                if (title != null) {
                    title.getSubBodyParts().addAll(result);
                    continue;
                }
                result.stream().forEach(a -> {
                    boolean bl = returnedElements.add(expectedReturnedClass.cast(a));
                });
            }
        }
        return returnedElements;
    }
}

