/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.gmf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations.GeneratorConfigurationOperations;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Image;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate.PapyrusGMFDiagramView;
import org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate.PapyrusGMFDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.integration.gmf.template2structure.internal.mapping.GMFDiagramImageUtils;

public class PapyrusGMFDiagramViewMapper
extends AbstractTemplateToStructureMapper<PapyrusGMFDiagramView> {
    public PapyrusGMFDiagramViewMapper() {
        super(PapyrusGMFDocumentStructureTemplatePackage.eINSTANCE.getPapyrusGMFDiagramView(), Image.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, PapyrusGMFDiagramView gmfDiagramView, EObject semanticModelElement, Class<T> returnedClassType) {
        if (!gmfDiagramView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!gmfDiagramView.isGenerate()) {
            return Collections.emptyList();
        }
        ArrayList<T> returnedValue = new ArrayList<T>();
        Iterator diagramIter = gmfDiagramView.getMatchingDiagrams(semanticModelElement).iterator();
        Title title = null;
        if (diagramIter.hasNext() && gmfDiagramView.isGenerateTitle()) {
            title = DocumentStructureFactory.eINSTANCE.createTitle();
            title.setTitle(gmfDiagramView.buildPartTemplateTitle(semanticModelElement));
            returnedValue.add(returnedClassType.cast(title));
        }
        while (diagramIter.hasNext()) {
            String XMI_ID;
            Image image = DocumentStructureFactory.eINSTANCE.createImage();
            Diagram current = (Diagram)diagramIter.next();
            image.setCaption(current.getName());
            DocumentTemplate t = null;
            EObject parent = gmfDiagramView.eContainer();
            while (t == null && parent != null) {
                if (parent instanceof DocumentTemplate) {
                    t = (DocumentTemplate)parent;
                    continue;
                }
                parent = parent.eContainer();
            }
            IDocumentStructureGeneratorConfiguration conf = t.getDocumentStructureGeneratorConfiguration();
            StringBuilder imageNameBuilder = new StringBuilder(current.getName().replaceAll("\\s+", ""));
            if (current.eResource() instanceof XMIResource && (XMI_ID = ((XMIResource)current.eResource()).getID((EObject)current)) != null && !XMI_ID.isEmpty()) {
                imageNameBuilder.append("_");
                imageNameBuilder.append(XMI_ID);
            }
            String imagePath = GeneratorConfigurationOperations.getImageFileLocalPath((IDocumentStructureGeneratorConfiguration)conf, (String)imageNameBuilder.toString(), (String)"svg");
            imagePath = imagePath.replaceAll("file:/", "");
            GMFDiagramImageUtils.generateImageOfDiagram(current, imagePath);
            image.setImagePath(imagePath);
            if (title == null) {
                returnedValue.add(returnedClassType.cast(image));
                continue;
            }
            title.getSubBodyParts().add((Object)image);
        }
        return returnedValue;
    }
}

