/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RiskIndex implements Enumerator
{
    _1(0, "1", "1"),
    _2(1, "2", "2"),
    _3(2, "3", "3"),
    _4(3, "4", "4"),
    _5(4, "5", "5"),
    _6(5, "6", "6");

    public static final int _1_VALUE = 0;
    public static final int _2_VALUE = 1;
    public static final int _3_VALUE = 2;
    public static final int _4_VALUE = 3;
    public static final int _5_VALUE = 4;
    public static final int _6_VALUE = 5;
    private static final RiskIndex[] VALUES_ARRAY;
    public static final List<RiskIndex> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RiskIndex[]{_1, _2, _3, _4, _5, _6};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RiskIndex get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskIndex result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskIndex getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskIndex result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskIndex get(int value) {
        switch (value) {
            case 0: {
                return _1;
            }
            case 1: {
                return _2;
            }
            case 2: {
                return _3;
            }
            case 3: {
                return _4;
            }
            case 4: {
                return _5;
            }
            case 5: {
                return _6;
            }
        }
        return null;
    }

    private RiskIndex(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

