/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Contract;
import org.eclipse.papyrus.robotics.assertions.ui.actions.ValidateAssertionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ValidateContractHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object result;
        EObject selectedObject = ValidateAssertionHandler.getSelectedElement();
        Contract contract = (Contract)UMLUtil.getStereotypeApplication((Element)((Element)selectedObject), Contract.class);
        StringBuffer message = new StringBuffer();
        boolean assumptionsProblem = false;
        boolean guaranteesProblem = false;
        if (!contract.getAssumptions().isEmpty()) {
            message.append("Assumtions\n");
            for (Assertion assumption : contract.getAssumptions()) {
                result = ValidateAssertionHandler.evaluateConstraint(assumption.getBase_Constraint());
                message.append("(" + result + ") ");
                if (result == null || !result.toString().equalsIgnoreCase("true")) {
                    assumptionsProblem = true;
                }
                message.append(String.valueOf(assumption.getBase_Constraint().getLabel()) + "\n");
            }
        }
        if (!contract.getGuarantees().isEmpty()) {
            message.append("Guarantees\n");
            for (Assertion guarantee : contract.getGuarantees()) {
                result = ValidateAssertionHandler.evaluateConstraint(guarantee.getBase_Constraint());
                message.append("(" + result + ") ");
                if (result == null || !result.toString().equalsIgnoreCase("true")) {
                    guaranteesProblem = true;
                }
                message.append(String.valueOf(guarantee.getBase_Constraint().getLabel()) + "\n");
            }
        }
        if (assumptionsProblem && !guaranteesProblem) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)message.toString());
        } else if (guaranteesProblem) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)message.toString());
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Contract", (String)message.toString());
        }
        return null;
    }
}

