/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.EnumerationLiteral;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XEnumLiteral;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XEnumeration;
import org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution.UnparseDT;
import org.eclipse.papyrus.robotics.xtext.datatypes.ui.internal.DatatypesActivator;
import org.eclipse.papyrus.robotics.xtext.util.TrackNames;
import org.eclipse.papyrus.robotics.xtext.util.UpdateContextAdapter;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.xtext.integration.AbstractXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.InvalidStringUtil;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class EnumerationEditorConfigurationContribution
extends AbstractXtextDirectEditorConfiguration {
    TrackNames<org.eclipse.uml2.uml.EnumerationLiteral> lastEnumLiterals;

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Enumeration) {
            Enumeration umlEnum = (Enumeration)editedObject;
            String invalidStr = InvalidStringUtil.getTextualRepresentation((Element)umlEnum);
            if (invalidStr != null) {
                return invalidStr;
            }
            return UnparseDT.getEnumText(umlEnum).toString();
        }
        return "Unexpected editor object";
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof Enumeration) {
            Enumeration umlEnum = (Enumeration)objectToEdit;
            this.lastEnumLiterals = new TrackNames(umlEnum.getOwnedLiterals());
        }
        return super.preEditAction(objectToEdit);
    }

    public ContextElementAdapter.IContextElementProvider getContextProvider() {
        return new UpdateContextAdapter(this.objectToEdit){

            public void updateLastNames() {
                XEnumeration xEnum = (XEnumeration)this.xtextResource.getContents().get(0);
                ArrayList<String> attrNameList = new ArrayList<String>();
                for (XEnumLiteral xEnumLiteral : xEnum.getLiterals()) {
                    attrNameList.add(xEnumLiteral.getName());
                }
                EnumerationEditorConfigurationContribution.this.lastEnumLiterals.update(attrNameList);
            }
        };
    }

    public int getStyle() {
        return 66;
    }

    public Injector getInjector() {
        return DatatypesActivator.getInstance().getInjector("org.eclipse.papyrus.robotics.xtext.datatypes.DTML");
    }

    public ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        TransactionalEditingDomain dom = TransactionUtil.getEditingDomain((EObject)umlObject);
        if (umlObject instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)umlObject;
            if (xtextObject instanceof XEnumeration) {
                CompositeCommand cc = new CompositeCommand("Update enumeration");
                for (org.eclipse.uml2.uml.EnumerationLiteral umlEnumLiteral : Lists.newArrayList((Iterable)enumeration.getOwnedLiterals())) {
                    if (this.lastEnumLiterals.containsValue((NamedElement)umlEnumLiteral)) continue;
                    DestroyElementRequest destroyReq = new DestroyElementRequest((EObject)umlEnumLiteral, false);
                    ICommand destroyCmd = ElementEditServiceUtils.getCommandProvider((EObject)enumeration).getEditCommand((IEditCommandRequest)destroyReq);
                    cc.add((IUndoableOperation)destroyCmd);
                }
                UpdateEnumerationCommand updateCommand = new UpdateEnumerationCommand(dom, enumeration, (XEnumeration)xtextObject);
                cc.add((IUndoableOperation)updateCommand);
                return cc;
            }
        }
        return null;
    }

    protected class UpdateEnumerationCommand
    extends AbstractTransactionalCommand {
        private Enumeration enumeration;
        private XEnumeration xEnum;

        public UpdateEnumerationCommand(TransactionalEditingDomain domain, Enumeration enumeration, XEnumeration xEnum) {
            super(domain, "Update enumeration", UpdateEnumerationCommand.getWorkspaceFiles((EObject)enumeration));
            this.enumeration = enumeration;
            this.xEnum = xEnum;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.enumeration.setName(this.xEnum.getName());
            this.enumeration.getOwnedLiterals().clear();
            for (XEnumLiteral xEnumLiteral : this.xEnum.getLiterals()) {
                org.eclipse.uml2.uml.EnumerationLiteral enumLiteral = (org.eclipse.uml2.uml.EnumerationLiteral)EnumerationEditorConfigurationContribution.this.lastEnumLiterals.get(xEnumLiteral.getName());
                if (enumLiteral == null) {
                    enumLiteral = UMLFactory.eINSTANCE.createEnumerationLiteral();
                }
                enumLiteral.setName(xEnumLiteral.getName());
                this.enumeration.getOwnedLiterals().add((Object)enumLiteral);
                EnumerationLiteral stEnumLiteral = (EnumerationLiteral)StereotypeUtil.applyApp((Element)enumLiteral, EnumerationLiteral.class);
                String comment = xEnumLiteral.getComment();
                if (stEnumLiteral != null && comment != null) {
                    comment = comment.substring(2).trim();
                    stEnumLiteral.setDescription(comment);
                }
                if (xEnumLiteral.getValue() != null) {
                    int value = xEnumLiteral.getValue().getIval();
                    ValueSpecification vs = enumLiteral.getSpecification();
                    if (vs instanceof LiteralInteger) {
                        ((LiteralInteger)vs).setValue(value);
                        continue;
                    }
                    if (vs != null) {
                        vs.destroy();
                    }
                    LiteralInteger li = UMLFactory.eINSTANCE.createLiteralInteger();
                    li.setValue(value);
                    enumLiteral.setSpecification((ValueSpecification)li);
                    continue;
                }
                ValueSpecification vs = enumLiteral.getSpecification();
                if (vs == null) continue;
                vs.destroy();
            }
            return CommandResult.newOKCommandResult((Object)this.enumeration);
        }
    }
}

