/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.provider.RoboticsLabelProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsMenuLabelProvider;
import org.eclipse.uml2.uml.Type;

public class MenuHelper {
    public static final String CREATE_NEW_TYPE = "Create new type";

    public static List<Object> createMenuItems(IStaticContentProvider cp, String title, boolean allowNew) {
        Object[] elements;
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(new EnhancedPopupMenu.Disabled(title));
        menuItems.add(new EnhancedPopupMenu.Separator());
        if (allowNew) {
            menuItems.add(CREATE_NEW_TYPE);
        }
        if ((elements = cp.getElements()).length > 0) {
            Object element;
            boolean containsURI = false;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                element = objectArray[n2];
                if (element instanceof URI) {
                    containsURI = true;
                    break;
                }
                ++n2;
            }
            if (elements.length < 5 && !containsURI) {
                if (elements[0] instanceof Type) {
                    menuItems.add(new EnhancedPopupMenu.Disabled("Existing types"));
                }
                objectArray = cp.getElements();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    element = objectArray[n2];
                    menuItems.add(element);
                    ++n2;
                }
            } else {
                menuItems.add(new EnhancedPopupMenu.SubSelect(title, (IStructuredContentProvider)cp));
            }
        }
        return menuItems;
    }

    public static EnhancedPopupMenu createPopupMenu(IStaticContentProvider cp, String title, boolean allowNew) {
        RoboticsMenuLabelProvider roboticsLP = new RoboticsMenuLabelProvider();
        return new EnhancedPopupMenu(MenuHelper.createMenuItems(cp, title, allowNew), (ILabelProvider)new RoboticsLabelProvider((ILabelProvider)roboticsLP));
    }
}

