/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class PortCommandUtils {
    public static void avoidDuplicatesCommand(Port port) {
        if (PortUtils.isCSDuplicate(port)) {
            try {
                PortUtils.associateCSCommand(port).execute(null, null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public static void addMoveCSCommand(CompositeCommand cc, Port port) {
        Type type = port.getType();
        if (type != null && StereotypeUtil.isApplied((Element)type, ComponentService.class) && port.getClass_() != type.getOwner()) {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)port);
            MoveRequest request = new MoveRequest((EObject)port.getClass_(), (EObject)type);
            cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
    }

    public static void addDeleteDependenciesCommand(CompositeCommand cc, Port port) {
        if (port.getType() instanceof Class) {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)port);
            Class clazz = (Class)port.getType();
            for (Dependency dep : clazz.getClientDependencies()) {
                DestroyElementRequest request = new DestroyElementRequest((EObject)dep, false);
                cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            }
        }
    }
}

