/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.robotics.core.Activator;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.osgi.framework.Bundle;

public class ScanUtils {
    private static final String ORG_ECLIPSE_EMF_ECORE_URI_MAPPING = "org.eclipse.emf.ecore.uri_mapping";

    public static List<URI> modelURIsInWorkspace(String extension) {
        ArrayList<URI> list = new ArrayList<URI>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen()) {
                    ScanUtils.processContainer((IContainer)project, extension, list);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
        return list;
    }

    public static List<URI> pathmapsWithModels(String extension) {
        IConfigurationElement[] configElements;
        ArrayList<URI> list = new ArrayList<URI>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ORG_ECLIPSE_EMF_ECORE_URI_MAPPING);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String source = configElement.getAttribute("source");
            String target = configElement.getAttribute("target");
            URI uri = URI.createURI((String)target);
            if (uri.isPlatformPlugin()) {
                String pluginId = uri.segment(1);
                Bundle bundle = Platform.getBundle((String)pluginId);
                String path = uri.toPlatformString(false).substring(pluginId.length() + 2);
                if (bundle != null && ScanUtils.hasBundleModels(bundle, path, extension)) {
                    list.add(URI.createURI((String)source));
                }
            }
            ++n2;
        }
        return list;
    }

    public static List<URI> modelsFromPath(URI uri, String extension) {
        IConfigurationElement[] configElements;
        ArrayList<URI> list = new ArrayList<URI>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        String uriStr = uri.toString();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ORG_ECLIPSE_EMF_ECORE_URI_MAPPING);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            URI targetUri;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String source = configElement.getAttribute("source");
            String target = configElement.getAttribute("target");
            if (source.equals(uriStr) && (targetUri = URI.createURI((String)target)).isPlatformPlugin()) {
                String pluginId = targetUri.segment(1);
                Bundle bundle = Platform.getBundle((String)pluginId);
                String path = targetUri.toPlatformString(false).substring(pluginId.length() + 1);
                if (bundle != null) {
                    ScanUtils.scanBundle(bundle, source, path, path, extension, list);
                }
            }
            ++n2;
        }
        return list;
    }

    public static List<URI> allPathmapModels(String extension) {
        ArrayList<URI> list = new ArrayList<URI>();
        for (URI uri : ScanUtils.pathmapsWithModels(extension)) {
            list.addAll(ScanUtils.modelsFromPath(uri, extension));
        }
        return list;
    }

    protected static boolean hasBundleModels(Bundle bundle, String path, String extension) {
        Enumeration urlEnum = bundle.findEntries(path, "*", false);
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                URL url = (URL)urlEnum.nextElement();
                if (url.getPath().endsWith(extension)) {
                    return true;
                }
                boolean found = ScanUtils.hasBundleModels(bundle, url.getPath(), extension);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    protected static void scanBundle(Bundle bundle, String pathmap, String initialPath, String path, String extension, List<URI> list) {
        Enumeration urlEnum = bundle.findEntries(path, "*", false);
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                URL url = (URL)urlEnum.nextElement();
                if (url.getPath().endsWith(extension)) {
                    String modelPath = String.valueOf(pathmap) + url.getPath().replaceFirst(initialPath, "");
                    URI uri = URI.createURI((String)modelPath);
                    list.add(uri);
                    continue;
                }
                ScanUtils.scanBundle(bundle, pathmap, initialPath, url.getPath(), extension, list);
            }
        }
    }

    public static EObject moveIntoRS(ResourceSet targetRS, EObject value) {
        Resource sourceRes = value.eResource();
        if (sourceRes.getResourceSet() != targetRS) {
            URI sourceURI = sourceRes.getURI();
            Resource targetRes = targetRS.getResource(sourceURI, true);
            return targetRes.getEObject(sourceRes.getURIFragment(value));
        }
        return value;
    }

    public static Class getCompFromResource(Resource r) {
        TreeIterator iter = r.getAllContents();
        while (iter.hasNext()) {
            EObject candidate = (EObject)iter.next();
            if (!(candidate instanceof Class) || !StereotypeUtil.isApplied((Element)((Class)candidate), ComponentDefinition.class)) continue;
            return (Class)candidate;
        }
        return null;
    }

    public static Class getSystemFromResource(Resource r) {
        TreeIterator iter = r.getAllContents();
        while (iter.hasNext()) {
            EObject candidate = (EObject)iter.next();
            if (!(candidate instanceof Class) || !StereotypeUtil.isApplied((Element)((Class)candidate), System.class)) continue;
            return (Class)candidate;
        }
        return null;
    }

    public static void processContainer(IContainer container, String extension, List<URI> list) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                ScanUtils.processContainer((IContainer)member, extension, list);
            } else if (member instanceof IFile && member.getName().endsWith(extension)) {
                IFile file = (IFile)member;
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                list.add(uri);
            }
            ++n2;
        }
    }
}

